package nsdb;


/**
* nsdb/LocationOperations.java .
* Generated by the IDL-to-Java compiler (portable), version "3.1"
* from corba/nsdb.idl
* Tuesday, March 7, 2006 12:49:15 PM GMT
*/


/**
       * A location is built from one or more nodes forming a tree
       * local node IDs are only unique within a location tree
       * the root node has id == 0
       * the Node id defines the position of the node in the sequence<LocationNode>
       * The value is relative to the current (parent) node
       * e.g if the current node is at position x in the LocationNodes sequence
       *     and there is a childId with value j
       *     then the position of this child in the LocationNodes sequence will be x+j
       */
public interface LocationOperations 
{

  /**
  	 * retrieve 
  	 * <A href="http://www.ebi.ac.uk/ebi_docs/embl_db/ft/components.html#location">
  	 * string representation of location</A>
  	 */
  String getLocationString ();

  /**
  	 * retrieve tree representation of location
  	 */
  nsdb.LocationPackage.LocationNode_u[] getNodes ();

  /**
  	 * Create nucleotide sequence defined by location. This can imply getting
  	 * fragments from multiple sequences and concatenating.
  	 * If it is not possible to resolve the location into a single sequence
  	 * (e.g. when it contains a 'group' operator, or gap nodes)
  	 * each fragment will be returned as a seperate string. No assumption should be
  	 * made on the order, if multiple fragments are returned
           * @raises InexactLocation if an exact sequence cannot be
  	 *   determined due to the location being inexact
  	 */
  String getSeq () throws nsdb.InexactLocation;
} // interface LocationOperations
