package nsdb;


/**
* nsdb/NucFeatureOperations.java .
* Generated by the IDL-to-Java compiler (portable), version "3.1"
* from corba/nsdb.idl
* Tuesday, March 7, 2006 12:49:15 PM GMT
*/


/**
       * Nucleotide Sequence Feature interface. Features are <I>owned</I> by a
       * sequence and contain information about that (and maybe other) sequence.
       * The relation between the feature and the sequence is defined by it's
       * location.
       * @see Location
       */
public interface NucFeatureOperations  extends seqdb.FeatureOperations
{

  /**
  	 * Retrieve sequence of qualifiers.
  	 * @raises type::NoResult if no qualifiers are associated with
  	 *    the feature.
  	 */
  nsdb.NucFeaturePackage.Qualifier[] getQualifiers () throws type.NoResult;

  /**
  	 * retrieve qualifier of a certain type.
  	 * To find out which qualifier/feature combinations are valid, a client should
  	 * query the NucFeatureMeta server.
  	 * @raises type::NoResult if no qualifier of this type is associated with
  	 *   the feature
  	 * @raises type::InvalidRelation if the requested qualifier cannot be
  	 *   associated to the current feature type
  	 * @see metafeature::NucFeatureMeta
  	 */
  nsdb.NucFeaturePackage.Qualifier getQualifier (String qualifier_name) throws type.NoResult, type.InvalidRelation;

  /**
  	 * If the location of the feature references multiple sequences, get a 
  	 * sequence of all sequences referenced
  	 * This method is equivalent to retrieving the feature location, and looping
  	 *  through all location nodes to find the referenced sequences, converting 
  	 * the accession numbers into DbXref's.
  	 */
  type.DbXref[] getNucSeqs ();

  /**
  	 * retrieve location of feature.
  	 * @raises type::NoResult if no location is associated with the feature.
  	 */
  nsdb.FeatureLocation getLocation () throws type.NoResult;
} // interface NucFeatureOperations
