/*
 * OrderedHash.java
 *
 * Created on June 9, 2010, 2:53 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.biolegato.core.main;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 *
 * @author alvare
 */
public class OrderedHash<K, V> extends Hashtable<K, V> {
    List<K> keyList = new ArrayList<K>();
    
    /** Creates a new instance of OrderedHash */
    public OrderedHash() {
    }
    
    public OrderedHash(Map importMap) {
	putAll(importMap);
    }

    @Override
    public void clear () {
	super.clear();
	keyList.clear();
    }
	    
    @Override
    public Enumeration<V> elements() {
	return new EnumeratingItterator<V>(values().iterator());
    }
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
	ArrayList<Map.Entry<K, V>> entries = new ArrayList<Map.Entry<K, V>>();
	
	for (K key : keyList) {
	    entries.add(new MapEntry(key, get(key)));
	}
	return new LinkedHashSet<Map.Entry<K, V>>(entries);
    }
    @Override
    public Enumeration<K> keys() {
	return new EnumeratingItterator<K>(keyList.listIterator());
    }
    @Override
    public Set<K> keySet() {
	return new LinkedHashSet<K>(keyList);
    }
    @Override
    public Collection<V> values() {
	ArrayList<V> values = new ArrayList<V>();
	
	for (K key : keyList) {
	    values.add(get(key));
	}
	return values;
    }

    
    // ORDERED HASH-SPECIFIC FUNCTIONS
    public K getKey (int number) {
	return keyList.get(number);
    }
    
    public int getKeyCount () {
        return keyList.size();
    }
    
    
    // MODIFICATION FUNCTIONS
    @Override
    public V put (K key, V value) {
	if (!containsKey(key)) {
	    keyList.add(key);
	}
	return super.put(key, value);
    }
    @Override
    public void putAll (Map<? extends K, ? extends V> map) {
	keyList.addAll(map.keySet());
	super.putAll(map);
    }
    @Override
    public V remove (Object key) {
	keyList.remove(key);
	return super.remove(key);
    }
    
    // TOSTRING
    @Override
    public String toString () {
	StringBuffer b = new StringBuffer();
	toString(b, 1);
        return b.toString();
    }
    private final void toString (StringBuffer b, int scope) {
	boolean comma = false;
	Object current = null;

	b.append("{");
	b.append("\n");
	for (K key : keySet()) {
	    if (comma) {
		b.append(",\n");
	    }
	    for (int count = 0; count < scope; count++) {
		b.append("    ");
	    }
	    b.append(key).append("=");
	    current = get(key);
	    if (current instanceof OrderedHash) {
		((OrderedHash)current).toString(b, scope + 1);
	    } else {
		b.append(current);
	    }
	    comma = true;
	}
	b.append("\n");
	for (int count = 0; count < scope - 1; count++) {
	    b.append("    ");
	}
	b.append("}");
    }
    
    public class EnumeratingItterator<T> implements Enumeration<T> {
	private Iterator<T> itt;
	public EnumeratingItterator(Iterator<T> i) {
	    this.itt = i;
	}

	public boolean hasMoreElements() {
	    return itt.hasNext();
	}

	public T nextElement() {
	    return itt.next();
	}
    }
    
    public class MapEntry<H,I> implements Map.Entry<H,I> {
	private H key;
	private I value;
	public MapEntry(H key, I value) {
	    this.key = key;
	    this.value = value;
	}
	public H getKey() {
	    return key;
	}

	public I getValue() {
	    return value;
	}

	public I setValue(I newValue) {
	    I oldValue = this.value;
	    this.value = newValue;
	    return oldValue;
	}
    }
}
