/*
 * ActionThread.java
 *
 * Created on January 6, 2010, 4:12 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.biolegato.core.menu;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

/**
 * Class used for making abstract actions which launch threads.
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class ActionThread extends AbstractAction {

    /**
     * The action to perform.
     */
    private Runnable run = null;
    /**
     * This constant is used for serialization
     */
    private static final long serialVersionUID = 7526472295622777001L;

    /**
     * Creates a new instance of ActionThread.
     *
     * @param name the name of the action
     * @param run the command for the thread to run
     */
    public ActionThread (String name, Runnable run) {
	super(name);
	this.run = run;
    }

    /**
     * Runs the command.
     *
     * @param e ignored by this function
     */
    public void actionPerformed (ActionEvent e) {
	new Thread(run).start();
    }
}
