/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.biolegato.core.menu;

import java.util.Map;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import org.biolegato.core.main.BLMain;

/**
 * The window used for setting options to run a menu command.
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class EZMenuItem extends JMenuItem implements ActionListener {

    /**
     * The name of the command to run
     */
    protected String name;
    /**
     * The list of variabes currently used by the window.  This is used for
     * creating the runtime command string.
     */
    protected Map<String, Object> variables;
    /**
     * The name of the menu item to use on error.
     */
    private static final String NAME_MISSING = "ERROR!";
    /**
     * Used in serialization.
     */
    private static final long serialVersionUID = 7526472295622777007L;

    /**
     * Creates a new instance of a run window.
     *
     * @param name the name of the run window.
     */
    public EZMenuItem(Map<String, Object> variables) {
	super(getNameFromHash(variables));
	
        // set the appropriate class variables
        this.name = name;
	this.variables = variables;
	
	addActionListener(this);
    }

    /**
     * Makes the window visible so all of the variables may be set.
     *
     * @param event this is currently ignored
     */
    public void actionPerformed(ActionEvent event) {
        new EZRunWindow(variables);
    }

    private static String getNameFromHash(Map<String, Object> variables) {
	String name = NAME_MISSING;
	
	try {
	    if (variables != null && variables.containsKey("name")) {
		name = (String) variables.get("name");
	    } else {
		BLMain.warning("Menu item missing name!");
	    }
	} catch (Throwable th) {
	    th.printStackTrace();
	}
	return name;
    }
}
