/*
 * EZRunWindow.java
 *
 * Created on January 5, 2010, 2:06 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
package org.biolegato.core.menu;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.biolegato.core.main.BLMain;
import org.biolegato.core.plugins.PluginLoader;
import org.biolegato.core.plugins.PluginWrapper;
import org.biolegato.core.menu.variables.EZCommandButton;
import org.biolegato.core.menu.variables.EZChoiceList;
import org.biolegato.core.menu.variables.EZChooser;
import org.biolegato.core.menu.variables.EZComboBox;
import org.biolegato.core.menu.variables.EZFileChooser;
import org.biolegato.core.menu.variables.EZSlider;
import org.biolegato.core.menu.variables.EZTempFile;
import org.biolegato.core.menu.variables.EZTextField;
import org.biolegato.core.menu.variables.EZVariable;
import org.biolegato.core.menu.variables.EZWidgetVariable;

/**
 *
 * @author alvare
 */
public class EZRunWindow {

    /**
     * Variable list - used for updating variable status
     */
    protected Map<String, Object> variableMapList;
    /**
     * The current window
     */
    protected JDialog runWindow = null;
    /**
     * List of widgets for the window.
     */
    protected HashMap<String, EZVariable> variableHash = new HashMap<String, EZVariable>();
    /**
     * Used in serialization.
     */
    private static final long serialVersionUID = 7526472295622777007L;

    /** Creates a new instance of EZRunWindow */
    public EZRunWindow(Map<String, Object> programData) {
        // set the classes internal variables
        this.variableMapList = programData;

        /* THIS BLOCK OF CODE
         * Determines whether the program has widgets that require input.
         * If there are no widgets the program will launch automatically when called.
         */
	int widgetCount = 0;
	int buttonCount = 0;
        boolean isDisplayWindow = false;
        Map data;
	String name = "";
        String type = null;
        EZVariable variable = null;
	EZCommandButton execute = null;
        Container variablePane = new Box(BoxLayout.PAGE_AXIS);
	Container buttonPane = new Box(BoxLayout.LINE_AXIS);

	if (programData.containsKey("name")) {
	    name = (String) programData.get("name");
	}
	
        // create the variables and determine if they are widgets
        for (Map.Entry<String, Object> e : variableMapList.entrySet()) {
	    if (e.getValue() instanceof Map) {
                data = (Map)e.getValue();
                if (data.containsKey("type")) {
                    type = data.get("type").toString().trim().toLowerCase();
                    if ("button".equals(type)) {
			execute = new EZCommandButton(this, data);
                        variable = execute;
			buttonPane.add(new JButton(execute));
			buttonCount++;
                    } else {
                        if ("tempfile".equals(type)) {
                            variable = new EZTempFile(data);
                        } else {
                            if ("slider".equals(type)) {
                                variable = new EZSlider(data);
                            } else if ("choice_menu".equals(type)) {
                                variable = new EZComboBox(data);
                            } else if ("choice_list".equals(type)) {
                                BLMain.warning("Using deprecated menu widget \"choice_list\"");
                                variable = new EZChoiceList(data);
                            } else if ("chooser".equals(type)) {
                                variable = new EZChooser(data);
                            } else if ("text".equals(type)) {
                                variable = new EZTextField(data);
                            } else if ("file_chooser".equals(type)) {
                                variable = new EZFileChooser(data);
                            }
			    variablePane.add((EZWidgetVariable) variable);
			    widgetCount++;
                        }
                        // NOTE: this must be lower case to prevent case sensitivity
			variableHash.put(e.getKey().toLowerCase(), variable);
                    }
                }
                if (variable == null) {
                    BLMain.error("Invalid variable: " + type + " (check your plugin directory, properties file, and menu files for possible errors)", "EZRunWindow.createVariable");
                }
	    }
        }

        if (widgetCount <= 0 && buttonCount <= 1 && execute != null) {
            new Thread(execute).start();
        } else {
	    runWindow = new JDialog(BLMain.getJFrame(), "BioLegato: " + name, true);
            Container panel = null;
            Container windowPane = new Box(BoxLayout.PAGE_AXIS);

            // create the pane and make it scrollable
            runWindow.setContentPane(new JScrollPane(windowPane));
            windowPane.add(variablePane);
            windowPane.add(buttonPane);

            // clean up and display the window
            runWindow.setMinimumSize(new Dimension(50, 50));
            runWindow.setSize(new Dimension(100, 100));
            runWindow.setLocationRelativeTo(BLMain.getJFrame());
            runWindow.setVisible(false);

            runWindow.pack();
            runWindow.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
            runWindow.setVisible(true);
	}
    }

    public synchronized void closeWindow() {
        String search = "";
	Map current = null;

	if (runWindow != null) {
	    runWindow.setVisible(false);
	}
	
	try {
	    // update the values of all used variables
	    for (Map.Entry<String, EZVariable> key : variableHash.entrySet()) {
		if (key != null && key.getValue() instanceof EZWidgetVariable
			&& variableMapList.containsKey(key.getKey())
			&& variableMapList.get(key.getKey()) instanceof Map) {
		    current = ((Map)variableMapList.get(key.getKey()));
		    current.put("default", ((EZWidgetVariable) key.getValue()).getNewDefault());
		}
	    }
	} catch (Throwable th) {
	    th.printStackTrace();
	}
	
	// destroy the current run window
        if (runWindow != null) {
            runWindow.dispose();
        }
        runWindow = null;
    }
    
    /**
     * Used to create BioLegato variables.
     *
     * @param data the data to create the variable with
     * @return the crated variable
     */
    public final EZVariable createVariable(Map data) {
        String type = null;
        EZVariable result = null;

        if (data.containsKey("type")) {
            type = data.get("type").toString().trim().toLowerCase();
            if ("slider".equals(type)) {
                result = new EZSlider(data);
            } else if ("choice_menu".equals(type)) {
                result = new EZComboBox(data);
            } else if ("choice_list".equals(type)) {
                BLMain.warning("Using deprecated menu widget \"choice_list\"");
                result = new EZChoiceList(data);
            } else if ("chooser".equals(type)) {
                result = new EZChooser(data);
            } else if ("text".equals(type)) {
                result = new EZTextField(data);
            } else if ("tempfile".equals(type)) {
                result = new EZTempFile(data);
            } else if ("file_chooser".equals(type)) {
                result = new EZFileChooser(data);
	    } else if ("button".equals(type)) {
		result = new EZCommandButton(this, data);
            }
        }
        if (result == null) {
            BLMain.error("Invalid variable type: " + type + " (check your plugin directory, properties file, and menu files for possible errors)", "EZRunWindow.createVariable");
        }
        return result;
    }

    public Map<String, EZVariable> getVariableHash() {
	return variableHash;
    }
}
