package org.biolegato.core.menu;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.File;
import java.util.LinkedList;
import java.util.Map;
import org.biolegato.core.main.BLMain;
import org.biolegato.core.main.OrderedHash;

/**
 * GDEMenu is used to read and parse GDE menu files into into BioLegato
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class GDEMakeMenus {

    /**
     * Reads in the makemenus GDE menus.
     */
    public static void loadMenu() {
        boolean possible;
        char[] system;
        String line;
        File menufile = null;
        File localmenudirfile;
        String dirname = "";
        String basedir = "";
        File menulist = null;
        LinkedList<String> menulistArray = new LinkedList<String>();
        OrderedHash<String, OrderedHash<String, File>> menu = new OrderedHash<String, OrderedHash<String, File>>();
        BufferedReader reader = null;					    // the BufferedReader for reading the GDE menu
        BufferedReader localreader = null;				    // the BufferedReader for reading the GDE menu

        // read in menus from the GDE directory
        if (System.getenv("GDE_MAKEMENUS_DIR") != null) {
            basedir = System.getenv("GDE_MAKEMENUS_DIR");
            menulistArray.add(basedir + File.separator + "menus");

            localmenudirfile = new File(basedir + File.separator + "ldir.param");
            if (localmenudirfile.exists() && localmenudirfile.canRead() && localmenudirfile.isFile()) {
                try {
                    localreader = new BufferedReader(new FileReader(localmenudirfile));
                    while ((line = localreader.readLine()) != null) {
                        menulistArray.add(line);
                    }
                    localreader.close();
                    localreader = null;
                } catch (Throwable e) {
                    e.printStackTrace();
                }
            }

            for (String currentFile : menulistArray) {
                menulist = new File(currentFile + File.separator + "menulist");
                if (menulist.exists() && menulist.canRead() && menulist.isFile()) {
                    try {
                        reader = new BufferedReader(new FileReader(menulist));

                        while ((line = reader.readLine()) != null) {
                            possible = true;
                            if (line.length() > 0 && !line.trim().equals("")) {
                                if (line.startsWith("#")) {
                                } else if (Character.isWhitespace(line.charAt(0))) {
                                    // menu item
                                    line = line.trim();
                                    if (line.indexOf('\t') >= 0) {
                                        // TODO system specific!
                                        system = line.substring(line.indexOf('\t') + 1).trim().toCharArray();
                                        line = line.substring(0, line.indexOf('\t'));
                                        if (system.length >= 0) {
                                            possible = false;
                                            for (char av : system) {
                                                if (("solaris-sparc".equalsIgnoreCase(System.getenv("BIRCH_PLATFORM")) && av == 'S')
                                                        || ("solaris-amd64".equalsIgnoreCase(System.getenv("BIRCH_PLATFORM")) && av == 's')
                                                        || ("linux-intel".equalsIgnoreCase(System.getenv("BIRCH_PLATFORM")) && av == 'L')
                                                        || ("linux-x86_64".equalsIgnoreCase(System.getenv("BIRCH_PLATFORM")) && av == 'l')) {
                                                    possible = true;
                                                }
                                            }
                                            if (BLMain.debug) {
                                                BLMain.message("BIRCH Makemenus: " + line + "    " + new String(system) + "    " + System.getenv("BIRCH_PLATFORM") + "    " + (possible ? "loaded" : "NOT loaded"));
                                            }
                                        }
                                    }

                                    if (possible) {
                                        menufile = new File(currentFile + File.separatorChar + dirname + File.separatorChar + line + ".item");
                                        if (menufile.exists() && menufile.isFile() && menufile.canRead()) {
                                            menu.get(dirname).put(line, menufile);
                                        } else {
                                            BLMain.error("Cannot read menu item: " + menufile.getAbsolutePath()
                                                    + "   " + menufile.exists() + "   " + menufile.isFile() + "   " + menufile.canRead(), "GDEMakeMenus plugin");
                                        }
                                    }
                                } else {
                                    // dirname
                                    dirname = line;
                                    if (!menu.containsKey(dirname)) {
                                        menu.put(dirname, new OrderedHash<String, File>());
                                    }
                                }
                            }
                        }
                        reader.close();
                    } catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }

            for (Map.Entry<String, OrderedHash<String, File>> directory : menu.entrySet()) {
                for (File file : directory.getValue().values()) {
                    GDEMenuParser.readGDEMenuFile(directory.getKey(), file);
                }
            }
        } else {
            BLMain.warning("GDE_MAKEMENUS_DIR not set!", "GDE Makemenus plugin");
        }
    }
}
