package org.biolegato.core.menu;

import java.io.File;
import java.util.LinkedList;
import org.biolegato.core.main.BLMain;

/**
 * GDEMenu is used to read and parse GDE menu files into into BioLegato
 * 
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class GDEMenu {

    /**
     * Reads in the default .GDEMenus files.
     */
    public static void loadMenu() {
	try {
	    // check the settings before reading in the menus
	    if (!"true".equalsIgnoreCase(BLMain.getProperty("GDE.menu.disable"))) {
		// read in menus from the GDE directory
		if (System.getenv("GDE_HELP_DIR") != null) {
		    GDEMenuParser.readGDEMenuFile(new File(System.getenv("GDE_HELP_DIR") + File.separator + ".GDEmenus"));
		} else {
		    BLMain.warning("GDE_HELP_DIR not set!", "GDEMenu plugin");
		}

		// read in menus from the current working directory
		GDEMenuParser.readGDEMenuFile(new File(BLMain.PROGRAM_DIR + File.separator + ".GDEmenus"));

		// read in menus from the home directory
		if (BLMain.HOME_DIR != null) {
		    GDEMenuParser.readGDEMenuFile(new File(BLMain.HOME_DIR + File.separator + ".GDEmenus"));
		} else {
		    BLMain.warning("HOME not set!", "GDEMenu plugin");
		}
	    }
	} catch (Throwable e) {
	    e.printStackTrace();
	}
    }
}
