/*
 * GDEMenuParser.java
 *
 * Created on June 9, 2010, 1:28 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
package org.biolegato.core.menu;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import org.biolegato.core.main.BLMain;
import org.biolegato.core.main.OrderedHash;

/**
 *
 * @author alvare
 */
public class GDEMenuParser {

    /** Creates a new instance of GDEMenuParser */
    public GDEMenuParser() {
    }

    /**
     * This function loads a GDE formatted menu file into the program.
     *
     * @param menuName the name of the current heading.
     * @param file the file to read.
     */
    public static void readGDEMenuFile(File file) {
        readGDEMenuFile("File", file);
    }

    /**
     * This function loads a GDE formatted menu file into the program.
     *
     * @param menuName the name of the current heading.
     * @param file the file to read.
     */
    public static void readGDEMenuFile(String menuName, File file) {
        String line = "";							    // the current line in the file
        String fname = "";							    // The current field name being parsed
        String fvalue = "";							    // The current field value
        String itemName = "";							    // The current menu item's name
        String runCommand = null;						    // The data for the current run button (used only on button creation)
        String helpCommand = null;						    // The data for the current help button (used only on button creation)
        BufferedReader reader = null;						    // the BufferedReader for reading the GDE menu
        JMenuItem jmitemp = null;						    // temporary vairble for adding action listeners to the JMenuItem
        List<String> argList = new LinkedList<String>();			    // used for replacing GDE regular variable names with BioLegato variable names
        List<String> fileVariables = new LinkedList<String>();			    // used for replacing GDE file variable names with BioLegato variable names
        OrderedHash<String, Object> currentItem = null;				    // the current menu item being processed
        OrderedHash<String, String> choices = new OrderedHash<String, String>();    // Used for storing variable choices
        Map<String, Object> infile = new HashMap<String, Object>();		    // The data for the current input file
        Map<String, Object> outfile = new HashMap<String, Object>();		    // The data for the current output file
        Map<String, Object> arg = new HashMap<String, Object>();		    // The data for the current argument

        if (file.exists() && file.isFile() && file.canRead()) {
            try {
                // open the file
                reader = new BufferedReader(new FileReader(file));
                do {
                    // read the next line
                    fname = "";
                    fvalue = "";
                    line = reader.readLine();

                    // skip comments and blank lines and make sure that there is a :
                    if (line != null && !"".equals(line) && line.indexOf(':') >= 0 && (line.startsWith("#@") || !line.startsWith("#"))) {
                        // remove biolegato specific parsing header (since we wish to parse these commands)
                        if (line.startsWith("#@")) {
                            line = line.substring(2);
                        }

                        // the first parameter is the field name
                        // the second parameter is the field data
                        fname = line.substring(0, line.indexOf(':')).trim().toLowerCase();
                        fvalue = line.substring(line.indexOf(':') + 1).trim();
                    }

//////////////////////////////////////////////////
//**********************************************//
//* add any pending arguments to the menu item *//
//**********************************************//
//////////////////////////////////////////////////
                    if (currentItem != null) {
                        if ((line == null || "item".equals(fname) || "arg".equals(fname) || "in".equals(fname) || "menu".equals(fname)) && infile.containsKey("name")) {
                            infile.put("type", "tempfile");
                            infile.put("source", "selection");
                            currentItem.put('%' + (String) infile.get("name"), infile);
                            fileVariables.add(((String) infile.get("name")).toLowerCase());
                            infile = new HashMap<String, Object>();
                        }
                        if ((line == null || "item".equals(fname) || "arg".equals(fname) || "out".equals(fname) || "menu".equals(fname)) && outfile.containsKey("name")) {
                            outfile.put("type", "tempfile");
                            outfile.put("dest", "newseq");
                            currentItem.put('%' + (String) outfile.get("name"), outfile);
                            fileVariables.add(((String) outfile.get("name")).toLowerCase());
                            outfile = new HashMap<String, Object>();
                        }
                        if ((line == null || "item".equals(fname) || "arg".equals(fname) || "menu".equals(fname)) && arg.containsKey("name")) {
                            if (!choices.isEmpty() && arg.containsKey("default")) {
                                if (BLMain.testNumber(((String) arg.get("default")).toCharArray())) {
                                    try {
                                        arg.put("default", choices.getKey(Integer.parseInt((String) arg.get("default"))));
                                    } catch (Throwable nfe) {
                                        nfe.printStackTrace();
                                    }
                                }
                            }
                            arg.put("choices", choices);
                            // this is necessary before doing any other processing
                            if (arg.containsKey("name") && arg.containsKey("type")) {
                                currentItem.put('%' + ((String) arg.get("name")).toLowerCase(), new HashMap<String, Object>(arg));
                                argList.add(((String) arg.get("name")).toLowerCase());
                            }
                            choices = new OrderedHash<String, String>();
                            arg = new HashMap<String, Object>();
                        }
                    }
                    //////////////////////////////
                    //**************************//
                    //* create a new menu item *//
                    //**************************//
                    //////////////////////////////
                    if (line == null || "item".equals(fname)) {
                        itemName = fvalue;
                        if (currentItem != null) {
                            GDE2BLArgs(argList, fileVariables, currentItem);
                            if (runCommand != null) {
                                currentItem.put("%Run", createGDEButton("Run", GDE2BLArgs(argList, fileVariables, runCommand), true));
                            }
                            if (helpCommand != null) {
                                currentItem.put("%Help", createGDEButton("Help", GDE2BLArgs(argList, fileVariables, helpCommand), false));
                            }
                        }
                        if (line != null) {
                            currentItem = new OrderedHash<String, Object>();
                            currentItem.put("name", itemName);

                            jmitemp = new EZMenuItem(currentItem);
                            BLMain.addMenuItem(menuName, jmitemp);
                            fileVariables.clear();
                            argList.clear();
                        }
                        runCommand = null;
                        helpCommand = null;
                    } // only do processing if the line is not null
                    else if (!"".equals(fname)) {
/////////////////////////////////
//*****************************//
//* create a new menu heading *//
//*****************************//
/////////////////////////////////
                        if ("menu".equals(fname)) {
                            menuName = fvalue;
                            BLMain.addMenuHeading(menuName);
                        } else if (currentItem != null) {

////////////////////////////////////
//********************************//
//* do menu item data processing *//
//********************************//
////////////////////////////////////
// this is optional for improving the usability of the menu item
                            if ("itemmeta".equals(fname) && fvalue.length() >= 1) {
                                // generate the mnemonic for the menu item
                                // this method allows only mnemonics of length 1
                                // (menu mnemonics in java are all of length 1, except complex ones involving shift/ctrl/etc.)
                                if ((fvalue.charAt(0) >= 'a' && fvalue.charAt(0) <= 'z') || (fvalue.charAt(0) >= 'A' && fvalue.charAt(0) <= 'Z')) {
                                    //currentItem.putValue(javax.swing.Action.MNEMONIC_KEY, new Integer(javax.swing.KeyStroke.getKeyStroke(fieldValue.charAt(0)).getKeyCode()));
                                }
                            } else if ("itemlabel".equals(fname)) {
                            } else if ("itemopen".equals(fname)) {
                            } else if ("itemhelp".equals(fname)) {
                                // obtain the help command for the menu item
                                helpCommand = BLMain.getProperty("GDE.help.viewer") + " " + BLMain.envreplace(BLMain.getProperty("GDE.help.path")) + File.separator + fvalue;

                            } else if ("itemmethod".equals(fname)) {
                                // get the command corresponding to the menu item
                                runCommand = fvalue;

                            } ////////////////////////////////////////
                            //************************************//
                            //* do argument parameter processing *//
                            //************************************//
                            ////////////////////////////////////////
                            // this is used to allow for parameter passing for running commands
                            else if ("arg".equals(fname)) {
                                // create a new argument parameter
                                arg.put("name", fvalue);
                            } else if ("argtype".equals(fname)) {
                                // changes the argument type
                                arg.put("type", fvalue);
                            } else if ("arglabel".equals(fname)) {
                                // changes the label of the command
                                arg.put("label", fvalue);
                            } else if ("argmin".equals(fname)) {
                                // changes the minimum value for the argument
                                // this is applicable only to number choosers
                                try {
                                    arg.put("min", Integer.parseInt(fvalue));
                                } catch (NumberFormatException nfe) {
                                    BLMain.error("Invalid GDE field value (item: " + itemName + "): " + fname + " = " + fvalue, "GDEMenu plugin");
                                }
                            } else if ("argmax".equals(fname)) {
                                // changes the maximum value for the argument
                                // this is applicable only to number choosers
                                try {
                                    arg.put("max", Integer.parseInt(fvalue));
                                } catch (NumberFormatException nfe) {
                                    BLMain.error("Invalid GDE field value (item: " + itemName + "): " + fname + " = " + fvalue, "GDEMenu plugin");
                                }
                            } else if ("argvalue".equals(fname) || "argtext".equals(fname)) {
                                // changes the default value for the argument
                                arg.put("default", fvalue);
                            } else if ("argchoice".equals(fname)) {
                                if (fvalue.indexOf(':') >= 0) {
                                    // adds a new choice for the argument
                                    // this is applicable only to selection widgets
                                    choices.put(fvalue.substring(0, fvalue.indexOf(':')),
                                            fvalue.substring(fvalue.indexOf(':') + 1));
                                } else {
                                    choices.put(fvalue, "");
                                    BLMain.warning("Badly formed argchoice field: " + fvalue, "GDEMenu");
                                }
                            } ///////////////////////////////////
                            //*******************************//
                            //* do I/O parameter processing *//
                            //*******************************//
                            ///////////////////////////////////
                            //***********************
                            //* Handle Input fields *
                            //***********************
                            else if ("in".equals(fname)) {
                                infile.put("name", fvalue);
                            } else if ("informat".equals(fname)) {
                                infile.put("format", fvalue);
                            } else if ("inmask".equals(fname)) {
                                BLMain.warning("Warning unsupported GDE menu field \"inmask\" -- ignoring", "GDEMenu");
                            } else if ("insave".equals(fname)) {
                                infile.put("save", "true");
                            } //************************
                            //* Handle Output fields *
                            //************************
                            else if ("out".equals(fname)) {
                                outfile.put("name", fvalue);
                            } else if ("outformat".equals(fname)) {
                                outfile.put("format", fvalue);
                            } else if ("outsave".equals(fname)) {
                                outfile.put("save", "true");
                            } else if ("outoverwrite".equals(fname)) {
                                outfile.put("overwrite", "true");
                            } else {
                                BLMain.error("Invalid GDE field (item: " + itemName + "): " + fname + " = " + fvalue, "GDEMenu plugin");
                            }
                        } else {
                            BLMain.error("Invalid GDE location or field value (item: " + itemName + "): " + fname + " = " + fvalue, "GDEMenu plugin");
                        }
                    }
                } while (line != null);

                // close the file
                reader.close();
            } catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static Map<String, Object> createGDEButton(String label, String command, boolean closeWindow) {
        Map<String, Object> button = new HashMap<String, Object>();
        button.put("label", label);
        button.put("type", "button");
        if (closeWindow) {
            button.put("closewindow", "true");
        } else {
            button.put("closewindow", "false");
        }
        button.put("command", command);
        return button;
    }

    private static String GDE2BLArgs(List<String> argList, List<String> fileVariables, String runCommand) {
        int start = -1;
        int end = -1;
        String name = "";
        String value = "";
        String[] argArray = argList.toArray(new String[0]);
        String smallrun = runCommand.toLowerCase();
        String test = null;
        Arrays.sort(argArray);

        // create the command string (NOTE: variable.toString().replaceAll(Pattern.quote("$"), "\\\\\\$") is used to prevent regex grouping (e.g. $0, etc.))
        while ((start = runCommand.indexOf('$', start)) >= 0) {
            end = start + 1;
            while (end < runCommand.length() && (BLMain.isDigit(runCommand.charAt(end)) || runCommand.charAt(end) == '_')) {
                end++;
            }
            test = runCommand.substring(start + 1, end).toLowerCase();
            if (Arrays.binarySearch(argArray, test) >= 0) {
                runCommand = (start == 0 ? "" : runCommand.substring(0, start)) + '%' + test + '%' + (end > runCommand.length() ? "" : runCommand.substring(end));
            }
            start++;
        }

        smallrun = runCommand.toLowerCase();
        for (String file : fileVariables) {
            int searchCount = 0;
            // reset the start and positions
            start = -1;
            end = -1;

            // make sure name is valid
            if (file != null && !"".equals(file)) {

                // itterate through and find each instance of the name to replace
                while ((start = smallrun.indexOf(file, end + 1)) >= 0) {
                    end = start + file.length();

                    // make sure that the name is not part of a bigger name
                    if ((start == 0 || BLMain.notDigit(runCommand.charAt(start - 1))) && (end >= runCommand.length() || BLMain.notDigit(runCommand.charAt(end)))) {
                        runCommand = (start == 0 ? "" : runCommand.substring(0, start)) + '%' + file + '%' + (end > runCommand.length() ? "" : runCommand.substring(end));
                        smallrun = runCommand.toLowerCase();
                    }
                }
            }
        }
        return runCommand;
    }

    private static void GDE2BLArgs(List<String> argList, List<String> fileVariables, Map<String, Object> map) {
        Map<String, Object> arg;
        for (String akey : argList) {
            arg = (Map<String, Object>) map.get('%' + akey);
            if (arg.containsKey("choices")) {
                for (Map.Entry<String, String> e :
                        ((Map<String, String>) arg.get("choices")).entrySet()) {
                    ((Map<String, String>) arg.get("choices")).put(e.getKey(), GDE2BLArgs(argList, fileVariables, e.getValue()));
                }
            }
        }
    }
}
