package org.biolegato.core.menu.variables;

import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import org.biolegato.core.main.BLMain;

/*
 * BLComboBox.java
 *
 * Created on June 16, 2008, 1:40 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
/**
 * A wrapper class used to abstract choice lists within command windows.
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class EZChoiceList extends EZWidgetVariable {

    /**
     * The list of choices
     */
    protected Map<String, String> choices = null;
    /**
     * The combobox contianing the data.
     */
    protected JList choice_list = null;
    /**
     * Used for serialization purposes.
     */
    private static final long serialVersionUID = 7526472295622776158L;

    /**
     * Creates a new instance of GDEComboBox (represents "choice_list" in GDE menu files).
     *
     * @param data the data to create the combobox with.
     */
    public EZChoiceList(java.util.Map data) {
        super(data);

        int defaultEntry = 0;
        String[] orderChoices = null;         // used for default values

        // a combo box which returns its value when toString is called
        if (data.containsKey("label")) {
            this.add(new JLabel(data.get("label").toString()));
        }

        if (data.containsKey("choices") && data.get("choices") instanceof java.util.Map) {
            choices = (Map<String, String>) data.get("choices");
            choice_list = new JList(choices.keySet().toArray());

            // handle the default value for the list
            if (data.containsKey("default")) {
                for (Map.Entry<String, String> e : choices.entrySet()) {
                    if (e.getValue().toString().equalsIgnoreCase(data.get("default").toString())) {
                        choice_list.setSelectedValue(e.getKey(), true);
                    }
                }
            }
            // make the choice_list only support single selection
            choice_list.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

            // add the choice list (and make it scrollable)
            this.add(new JScrollPane(choice_list, JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED, JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED));
        } else {
            BLMain.error("Invalid argument (missing choice list)", "BLComboBox");
        }
    }

    /**
     * Returns the name of this type of variable.
     * 
     * @return the name of the variable type "choice_list".
     */
    public static String getType() {
        return "choice_list";
    }

    /**
     * This function is used to maintain user variable settings from window to window.
     * Each time a runwindow is closed, this function is called to ensure that the next time
     * the user opens the runwindow, the value of this variable will default to the same
     * value the user picked the last time the runwindow was open.
     *
     * @return the new default value for the variable
     */
    @Override
    public Object getNewDefault() {
        return choice_list.getSelectedValue();
    }

    /**
     * Returns the value of the variable.
     *
     * @return the current value of the widget.
     */
    public Object getValue() {
        return choices.get(choice_list.getSelectedValue());
    }
}
