package org.biolegato.core.menu.variables;

/*
 * BLRadioButtons.java
 *
 * Created on November 19, 2007, 2:45 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

/**
 * Wrapper class for a group of radiobuttons.
 * NOTE: This can be added to any JContainer since it extends JPanel.
 * 
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class EZChooser extends EZWidgetVariable implements ActionListener {

    /**
     * Stores the current value selected by the chooser.
     */
    private String value = "";
    /**
     * The list of radio buttons.  The hash-key is the text of the button,
     * the hash-value is the value associated with the button.
     */
    private Map<String, String> choices = null;      // the list of choices
    /**
     * Required for serialization purposes.
     */
    private static final long serialVersionUID = 7526472295622776152L;

    /**
     * Creates a new instance of EZChooser.
     *
     * @param data The value/name list of each of the radiobuttons
     */
    public EZChooser(java.util.Map<String, Object> data) {
        super(data);

        String[] entries = null;
        ButtonGroup group = new ButtonGroup();
        JPanel panel = new JPanel();
        JRadioButton radio;

        if (data.containsKey("label")) {
            this.add(new JLabel(data.get("label").toString()));
        }

        if (data.containsKey("choices") && data.get("choices") instanceof Map) {
            // add the radio buttons to the list
            choices = (Map<String, String>) data.get("choices");

            if (data.containsKey("default") && data.get("default") != null) {
                value = (String) data.get("default");
            }
            for (String entry : choices.keySet()) {
                radio = new JRadioButton(entry);
                panel.add(radio);
                radio.setActionCommand(entry);
                radio.addActionListener(this);
                if (entry.equalsIgnoreCase(value)) {
                    radio.setSelected(true);
                }
                group.add(radio);
            }
        }
        this.add(panel);
    }

    /**
     * Handles selection changes of the radio buttons.
     *
     * @param e used to determine which button is selected (by use of getActionCommand()).
     */
    public void actionPerformed(ActionEvent e) {
        value = e.getActionCommand();
    }

    /**
     * Returns the name of this type of variable.
     *
     * @return "chooser" - the name of the variable type.
     */
    public static String getType() {
        return "chooser";
    }

    /**
     * This function is used to maintain user variable settings from window to window.
     * Each time a runwindow is closed, this function is called to ensure that the next time
     * the user opens the runwindow, the value of this variable will default to the same
     * value the user picked the last time the runwindow was open.
     *
     * @return the new default value for the variable
     */
    @Override
    public Object getNewDefault() {
        return value;
    }

    /**
     * Returns the value of the variable.
     *
     * @return the current value of the variable
     */
    public Object getValue() {
        return (choices != null ? choices.get(value) : "");
    }
}
