/*
 * EZCommandButton.java
 *
 * Created on June 3, 2010, 11:52 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.biolegato.core.menu.variables;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.AbstractAction;
import org.biolegato.core.main.BLMain;
import org.biolegato.core.menu.EZRunWindow;

/**
 *
 * @author alvare
 */
public class EZCommandButton extends AbstractAction implements Runnable, EZVariable {
    boolean close = false;
    String command;
    EZRunWindow window;
    
    /** Creates a new instance of EZCommandButton */
    public EZCommandButton(EZRunWindow window, Map data) {
	super((String) data.get("label"));
	this.window = window;
	
        if (data.containsKey("command")) {
            command = data.get("command").toString().trim();
        } else {
            BLMain.error("Field is missing a variable name", "BLVariable constructor");
            command = "";
        }
        if (data.containsKey("closewindow") && "true".equalsIgnoreCase((String)data.get("closewindow"))) {
            close = true;
        }
    }
    
    /**
     * Used for running the command.
     * <p>
     *	This function gathers all of the parameter settings from the widgets
     *	in the window, then generates and executes the corresponding command
     *	string.
     * </p>
     */
    public void run() {
	if (close) {
	    window.closeWindow();
	}

        // execute the program and collect program output
        BLMain.shellCommand(replaceArguments(command), "");

        // cleanup execution
        // releases all of the input files
        for (EZVariable var : window.getVariableHash().values()) {
	    var.close();
        }
    }

    /**
     * Replaces the variables in the command string with their corresponding values.
     *
     * @param run the command to do the replacements on.
     * @param widgets the widget variables to use for string replacement.
     * @param files the file variables to use for string replacement.
     * @return the altered command string.
     */
    protected String replaceArguments(String run) {
        int start = -1;
        int end = -1;
        String name = "";
        String value = "";
	Map<String, EZVariable> variableHash = window.getVariableHash();

	if (BLMain.debug) {
	    BLMain.message("--- debug keys ---");
	    for (String key : variableHash.keySet()) {
		BLMain.message("key - " + key + "=" + variableHash.get(key));
	    }
	}
	
        // create the command string (NOTE: variable.toString().replaceAll(Pattern.quote("$"), "\\\\\\$") is used to prevent regex grouping (e.g. $0, etc.))
        while ((start = run.indexOf('%', start)) >= 0) {
            end = start + 1;
            while (end < run.length() && run.charAt(end) != '%') {
                end++;
            }
	    if (start < end) {
		name = run.substring(start, end).toLowerCase();
		value = "";
		if (variableHash.containsKey(name)) {
		    value = variableHash.get(name).getValue().toString();
		    run = (start == 0 ? "" : run.substring(0, start)) + value + (end >= run.length() ? "" : run.substring(end + 1));
		    start--;
		} else {
		    start++;
		}
	    }
        }
        return run;
    }

    public void actionPerformed(ActionEvent e) {
	new Thread(this).start();
    }

    public Object getValue() {
	return this;
    }

    public String getName() {
	return null;
    }

    public void close() {
    }
}
