package org.biolegato.core.menu.variables;

/*
 * BLNumberSelector.java
 *
 * Created on 2007/11/26, 11:24
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/**
 * Wraps a widget(s) for selecting numeric values.
 * 
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class EZSlider extends EZWidgetVariable implements ChangeListener {
	/**
     * The slider portion of the number selector widget.
     */
	private JSlider slider = null;
	/**
     * The slider portion of the number selector widget.
     */
	private JSpinner spinner = null;
	/**
     * Used for serialization purposes.
     */
	private static final long serialVersionUID = 7526472295622776161L;

	/**
	 * Creates a new instance of EZSlider
	 * 
	 * @param data the map containing all of the information required to make the number selector.
	 */
	public EZSlider (java.util.Map data) {
		super(data);

		int defaultValue = 0;
		int minimum = 0;
		int maximum = 5000;

		if (data.containsKey("label")) {
			this.add(new JLabel(data.get("label").toString() + ":"));
		}
		if (data.containsKey("min") && data.get("min") instanceof Integer) {
			minimum = ((Integer) data.get("min")).intValue();
		}
		if (data.containsKey("max") && data.get("max") instanceof Integer) {
			maximum = ((Integer) data.get("max")).intValue();
		}
		if (data.containsKey("default")) {
			try {
				defaultValue = Integer.parseInt(data.get("default").toString());
			} catch (NumberFormatException nfe) {
			}
		}
		minimum = Math.max(0, minimum);
		maximum = Math.max(minimum, maximum);
		defaultValue = Math.max(Math.min(defaultValue, maximum), minimum);
		//add the spinner
		spinner = new JSpinner(new SpinnerNumberModel(defaultValue, minimum, maximum, 1));
		spinner.addChangeListener(this);
		this.add(spinner);

		this.add(new JLabel("" + minimum));
		// add the slider
		slider = new JSlider(JSlider.HORIZONTAL, minimum, maximum, defaultValue);
		slider.addChangeListener(this);
		this.add(slider);
		this.add(new JLabel("" + maximum));
	}

	/**
	 * Handles synchronization between the slider and the spinner.
     * 
	 * @param e used to determine which widget was changed.
	 */
	public void stateChanged (ChangeEvent e) {
		if (e.getSource() instanceof JSpinner) {
			slider.setValue(((Number) spinner.getValue()).intValue());
		} else {
			spinner.setValue(slider.getValue());
		}
	}

	/**
	 * Returns the name of this type of variable.
     *
	 * @return the name of the variable type -- "slider".
	 */
	public static String getType () {
		return "slider";
	}

	/**
	 * Returns the current value of the variable.
	 *
	 * @return the value selected by the slider/spinner.
	 */
	public Object getValue () {
		return spinner.getValue().toString();
	}
}
