package org.biolegato.core.menu.variables;

/*
 * GDEFileVariable.java
 *
 * Created on November 20, 2007, 4:06 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
import java.io.File;
import org.biolegato.core.main.BLMain;
import org.biolegato.core.pcdmenu.TempFile;

/**
 * Stores information about the file fields used by the command
 * 
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class EZTempFile implements EZVariable {

    /**
     * the name of the widget
     */
    private String name;
    /**
     * The currently opened file handle.
     */
    private TempFile tfile = null;

    /**
     * Creates a new instance of EZTempFile.
     * 
     * @param data the data to create the temporary file variable with.
     */
    public EZTempFile (java.util.Map data) {
        /**
         * Whether or not to add the contents of the window to the file before execution
         * (whether the temporary file is input for a program).
         */
        boolean input = false;
        /**
         * Whether or not to add the contents of the file to the window after execution.
         * (whether the temporary file is output for a program).
         */
        boolean output = false;
        /**
         * Determines whether or not to delete the file after execution.
         */
        boolean save = false;
        /**
         * Corresponds to GDE's inmask directive (unknown usage).
         */
        boolean mask = false;
        /**
         * Determines whether or not to overwrite the file if it already exists.
         */
        boolean overwrite = false;
        /**
         * Stores the file format of the file (used for translation).
         */
        String format = null;
        
        if (data.containsKey("name")) {
            name = data.get("name").toString().trim();
        } else {
            BLMain.error("Field is missing a variable name", "BLVariable constructor");
            name = "";
        }
        if (data.containsKey("format")) {
            format = data.get("format").toString();
        }
        if (data.containsKey("save") && "true".equalsIgnoreCase((String) data.get("save"))) {
            save = true;
        }
        if (data.containsKey("overwrite") && "true".equalsIgnoreCase((String) data.get("overwrite"))) {
            overwrite = true;
        }
        if (data.containsKey("mask") && "true".equalsIgnoreCase((String) data.get("mask"))) {
            mask = true;
        }
        if (data.containsKey("source") && "selection".equalsIgnoreCase((String)data.get("source"))) {
            input = true;
        }
        if (data.containsKey("dest") && "newseq".equalsIgnoreCase((String)data.get("dest"))) {
            output = true;
        }
        
        tfile = new TempFile(input, output, save, overwrite, format);
    }

    /**
     * Returns the name of the variable.
     *
     * @return the name of the variable
     */
    public String getName () {
        return name;
    }

    /**
     * Gets the current filename corresponding to this variable
     * If the file does not exists, then this function creates a file to
     * use for IO and writes any initial contents
     *
     * @return the filename to use for command line substitution.
     */
    public Object getValue () {
        return tfile.getValue();
    }

    /**
     * Releases any files currently in use by this class
     */
    public void close () {
        tfile.close();
    }

    /**
     * Returns the type name
     * @return "tempfile"
     */
    public static String getType () {
        return "tempfile";
    }

    /**
     * Returns the widget status of the variable (i.e., is the variable displayable)
     *
     * @return true if the variable contains a displayable component.
     */
    public boolean isWidget() {
	return false;
    }
}