package org.biolegato.core.menu.variables;

/*
 * BLTextField.java
 *
 * Created on June 16, 2008, 2:08 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JTextField;

/**
 * A wrapper class used to abstract text fields within command windows.
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class EZTextField extends EZWidgetVariable {

    /**
     * The textfield for obtaining the data
     */
    protected JTextField textfield = null;
    /**
     * Used for serialization purposes
     */
    private static final long serialVersionUID = 7526472295622776159L;

    /**
	 * Creates a new instance of EZTextField
	 * 
	 * 
	 * @param data the information for creating the text field.
	 */
    public EZTextField (java.util.Map data) {
        super(data);
	
        // a textbox which returns its value when toString is called
        textfield = new JTextField(20);

        // a combo box which returns its value when toString is called
        if (data.containsKey("label")) {
            this.add(new JLabel(data.get("label").toString()));
        }
        if (data.containsKey("default")) {
            textfield.setText(data.get("default").toString());
        }
        this.add(textfield);
    }

    /**
     * Returns the name of this type of variable
     *
     * @return the name of the variable type ("text")
     */
    public static String getType () {
        return "text";
    }

    /**
     * Returns the value of the variable.
     *
     * @return the current value of the variable class.
     */
    public Object getValue () {
        return textfield.getText();
    }
}
