package org.biolegato.core.menu.variables;

/*
 * BLVariable.java
 *
 * Created on June 12, 2008, 3:26 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import org.biolegato.core.main.BLMain;
import org.biolegato.core.plugins.PluginLoader;
import org.biolegato.core.plugins.PluginWrapper;

/**
 * A superclass used to abstract variables for creating command windows.
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public abstract class EZWidgetVariable extends Box implements EZVariable {

    protected Map original;
    
    /**
	 * Creates a new instance of EZVariable (used to add the name to the variable).
	 * 
	 * @param data the data to construct the variable with
	 */
    public EZWidgetVariable (Map data) {
	super(BoxLayout.LINE_AXIS);
	original = data;
    }

    /**
     * Returns the value of the variable.
     *
     * @return the value of the variable
     */
    public abstract Object getValue ();

    /**
     * Returns the name of this type of variable.
     *
     * @return the name of the variable type
     */
    public static String getType () {
        return "none";
    }

    /**
     * This function is used to maintain user variable settings from window to window.
     * Each time a runwindow is closed, this function is called to ensure that the next time
     * the user opens the runwindow, the value of this variable will default to the same
     * value the user picked the last time the runwindow was open.
     *
     * @return the new default value for the variable
     */
    public Object getNewDefault() {
	return getValue();
    }

    /**
     * Finalizes the current variable.  This includes closing.
     */
    public void close() {
    }
}
