package org.biolegato.core.pcdmenu;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import org.biolegato.core.main.BLMain;
import org.biolegato.core.pcdmenu.widgets.Widget;

/**
 * Creates a JButton, which when clicked runs internal API functions or external commands
 **
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class CommandButton implements Widget {
    private String label = null;
    private boolean close = false;
    private String command = null;
    private MenuWindow window = null;
    

    /**
     * Creates a new instance of CommandButton
     */
    public CommandButton(String label, String command, boolean close) {
        this.label = label;
        this.command = command;
        this.close = close;
    }
    
    public Component display() {
        JButton button = new JButton(label);
        
        button.addActionListener(new CommandThread(command, null /*widgets*/) {
            {if (window != null && close) {
                window.close();
            }}
        });
        
        return button;
    }

    public Object getValue() {
	return null;
    }

    public void close() {
    }
}
