package org.biolegato.core.pcdmenu;

import java.awt.Component;
import java.awt.Dimension;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JFrame ;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.biolegato.core.main.BLMain;
import org.biolegato.core.main.OrderedHash ;
import org.biolegato.core.pcdmenu.widgets.Widget;

public class MenuWindow extends JDialog {

    /**
     * Creates a new instance of EZComboBox (represents "choice_list" in GDE menu files).
     *
     * @param data the data to create the combobox with.
     */
    public MenuWindow(String name, OrderedHash<String, Widget> widgets) {
        super(BLMain.getJFrame(), name);
	Component display;
	JPanel panel = new JPanel();
	
        setContentPane(new JScrollPane(panel));
	panel.setLayout(new BoxLayout(panel, BoxLayout.PAGE_AXIS));

        /* displays each of the parameters */
        for (Widget current : widgets.values()) {
	    display = current.display();
	    System.out.println(current);
	    if (display != null) {
		panel.add(display);
	    } else {
		System.out.println("    null object");
	    }
        }

        // clean up and display the window
        setMinimumSize(new Dimension(50, 50));
        setSize(new Dimension(100, 100));
        setLocationRelativeTo(BLMain.getJFrame());
        setVisible(false);

        pack();
        setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
        setVisible(true);
    }

    void close() {
        setVisible(false);
        dispose();
    }
}