/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.biolegato.core.pcdmenu;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import javax.swing.JMenuItem;
import org.biolegato.core.main.BLMain;
import org.biolegato.core.pcdmenu.parser.PCDFile;
import org.biolegato.core.pcdmenu.parser.ParseException;

/**
 *
 * @author alvare
 */
public class PCDMenu {

    /**
     * Reads in the default .GDEMenus files.
     */
    public static void loadMenu() {
        String[] paths = null;

        try {
            // read in menus from the GDE directory
            if (System.getenv("BL_MENUS") != null) {
                paths = System.getenv("BL_MENUS").split(File.pathSeparator);

                for (String path : paths) {
                    readDirectory(new File(path));
                }
            } else {
                BLMain.warning("BL_MENUS not set!  Defaulting to " + BLMain.PROGRAM_DIR + File.separator + "menus", "PCD Menu plugin");
                readDirectory(new File(BLMain.PROGRAM_DIR + File.separator + "menus"));
            }
        } catch (Throwable th) {
            BLMain.error("Reading BioLegato menus failed!");
            th.printStackTrace();
        }
    }

    public static void readDirectory(File directory) {
        String dirname = null;
        String filename = null;
	FileInputStream filebuffer = null;
	JMenuItem item;
	PCDFile fileparser = null;

        // check that the directory exists, and iterate through its files
        try {
            if (directory != null && directory.exists() && directory.isDirectory()) {
                for (File file : directory.listFiles()) {
                    // branch based on whether the current entry is a class file, a jar file or a directory.
                    if (file.exists() && file.canRead()) {
                        if (file.isDirectory()) {
                            // if the entry is a directory, traverse the directory for files.
                            readDirectory(file.getAbsoluteFile());
                        } else {
                            dirname = directory.getAbsolutePath();
                            if (dirname.lastIndexOf(File.separatorChar) >= 0) {
                                dirname = dirname.substring(dirname.lastIndexOf(File.separatorChar) + 1);
                            }
                            filename = file.getAbsolutePath();
                            if (filename.lastIndexOf(File.separatorChar) >= 0) {
                                filename = filename.substring(filename.lastIndexOf(File.separatorChar) + 1);
                            }
			    try {
				filebuffer = new FileInputStream(file);
				if (fileparser == null) {
				    fileparser = new PCDFile(filebuffer);
				} else {
				    fileparser.ReInit(filebuffer);
				}
				item = fileparser.Parse();
				System.out.println(item.getName());
				BLMain.addMenuItem(dirname, item);
				
			    } catch (ParseException pe) {
				BLMain.error("parse error in file: " + file.getAbsolutePath());
				pe.printStackTrace();
			    }
                        }
                    }
                }
            }
        } catch (Throwable th) {
            th.printStackTrace();
        }
    }
}
