package org.biolegato.core.pcdmenu;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.biolegato.core.main.BLMain;
import org.biolegato.core.main.OrderedHash;
import org.biolegato.core.pcdmenu.widgets.Widget;

public class PCDMenuItem extends JMenuItem implements ActionListener, WidgetContainer {

    private String name;
    private String icon;
    private String tooltip;
    private OrderedHash<String, Widget> widgets = new OrderedHash<String, Widget>();

    public PCDMenuItem(String name, String icon, String tooltip) {
        super(name);
        
        this.name = name;
        this.icon = icon;
        this.tooltip = tooltip;
	this.addActionListener(this);
    }

    public void addWidget(String key, Widget w) {
	if (w != null) {
	    widgets.put(key, w);
	} else {
	    BLMain.error("Invalid parameter for widget");
	}
    }

    public void actionPerformed(ActionEvent e) {
        new MenuWindow(name, widgets);
    }
}
