/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.biolegato.core.pcdmenu;

import java.awt.Component;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.biolegato.core.main.OrderedHash;
import org.biolegato.core.pcdmenu.widgets.*;

/**
 *
 * @author alvare
 */
public class TabWidget extends OrderedHash<String,LinkedList<Widget>> implements Widget, WidgetContainer {
    /**
     * Creates a new instance of the tab widget
     */
    public TabWidget () {
        super();
    }

    public Component display () {
        /* The panel to add parameters to */
        JTabbedPane tpane = new JTabbedPane();
        /* The panel to add parameters to */
        JPanel panel;

        /* displays each of the parameters */
        for (Map.Entry<String,LinkedList<Widget>> entry : entrySet()) {
            panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, BoxLayout.PAGE_AXIS));
            for (Widget w : entry.getValue()) {
                panel.add(w.display());
            }
            tpane.addTab(entry.getKey(), panel);
        }

        return tpane;
    }

    public Object getValue() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void close() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addWidget(String key, Widget w) {
        if (!containsKey(key)) {
            put(key, new LinkedList<Widget>());
        }
        get(key).add(w);
    }
}
