/* Generated By:JavaCC: Do not edit this line. PCDFile.java */
package org.biolegato.core.pcdmenu.parser;

import java.util.LinkedList ;
import java.util.Map ;
import javax.swing.JMenuItem ;
import org.biolegato.core.main.BLMain ;
import org.biolegato.core.main.OrderedHash ;
import org.biolegato.core.pcdmenu.* ;
import org.biolegato.core.pcdmenu.widgets.* ;

public class PCDFile implements PCDFileConstants {
    private String  name              = null  ;
    private String  icon              = null  ;
    private String  tooltip           = null  ;

    private boolean systemTokenParsed = false ;
    private boolean systemSupported   = true  ;

/* PRODUCTIONS */

//////////////////////////////////////
/************************************/
/*                                  */
/* H H  EEE    A    DDD   EEE  RRR  */
/* H H  H     A A   D  D  E    R  R */
/* HHH  EEE  AAAAA  D  D  EEE  RRR  */
/* H H  E    A   A  D  D  E    R R  */
/* H H  EEE  A   A  DDD   EEE  R  R */
/*                                  */
/************************************/
//////////////////////////////////////

/**
 * Parses PCD files
 **
 * The format for a PCD file is:
 * [ Optional Blank Space ]
 * [ PCD Options ]
 * Tabs and Parameters
 */
  final public JMenuItem Parse() throws ParseException {
    /* The widget menu item generated from the data (if item is a widget bearing menu item) */
    PCDMenuItem pcditem = null;
    /* The menu item generated from the data */
    JMenuItem item = null;
    /* Temporarily stores parameters before they are added to the main panel */
    Widget param = null;
    /* The command to execute, if this is an execution command */
    String exec = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NL:
      jj_consume_token(NL);
      break;
    default:
      jj_la1[0] = jj_gen;
      ;
    }
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_ICON:
      case T_SYSTEM:
      case T_TIP:
      case T_CMDNAME:
        ;
        break;
      default:
        jj_la1[1] = jj_gen;
        break label_1;
      }
      PCDOption();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_SHELL:
      jj_consume_token(T_SHELL);
      exec = Text();
          item = new ExecMenuItem(exec, name, icon, tooltip);
      break;
    default:
      jj_la1[3] = jj_gen;
      if (jj_2_3(1)) {
          pcditem = new PCDMenuItem(name, icon, tooltip);
          item = pcditem;
        label_2:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case T_PARAM:
            Param(0, pcditem);
            break;
          default:
            jj_la1[2] = jj_gen;
            if (jj_2_1(1)) {
              Tab(0, pcditem);
            } else {
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          if (jj_2_2(1)) {
            ;
          } else {
            break label_2;
          }
        }
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(0);
      {if (true) return item;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a list of supported PCD options
 **
 * Currently supported options:
 *
 * <table>
 * <tr><th>Option name</th> <th>Description</th></tr>
 * <tr><td>name</td>        <td>the name of the PCD command</td></tr>
 * <tr><td>tip</td>         <td>the tool-tip text for the PCD command</td></tr>
 * <tr><td>icon</td>        <td>the path of the PCD command's icon file</td></tr>
 * <tr><td>system</td>      <td>a list of supported system configurations
 *                              for the PCD command</td></tr>
 * </table>
 **
 * @return whether the current operating system is supported by the PCD command
 */
  final public void PCDOption() throws ParseException {
    /* the token to store all of the information received about the option */
    Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_CMDNAME:
      jj_consume_token(T_CMDNAME);
      inorsp(1);
      t = jj_consume_token(TEXT);
      jj_consume_token(NL);
            /* Ensure that there are no duplicate name tokens */
            if (name != null) {
                {if (true) throw new ParseException("Duplicate \u005c"name\u005c" field on line: " + t.beginLine);}
            }

            /* Set the menu item name for the program */
            name    = t.image;
      break;
    case T_ICON:
      jj_consume_token(T_ICON);
      inorsp(1);
      t = jj_consume_token(TEXT);
      jj_consume_token(NL);
            /* Ensure that there are no duplicate icon tokens */
            if (icon != null) {
                {if (true) throw new ParseException("Duplicate \u005c"icon\u005c" field on line: " + t.beginLine);}
            }

            /* Set the icon file path for the program */
            icon    = t.image;
      break;
    case T_TIP:
      jj_consume_token(T_TIP);
      inorsp(1);
      t = jj_consume_token(TEXT);
      jj_consume_token(NL);
            /* Ensure that there are no duplicate tooltip ("tip") tokens */
            if (tooltip != null) {
                {if (true) throw new ParseException("Duplicate \u005c"tip\u005c" field on line: " + t.beginLine);}
            }

            /* Set the tooltip text for the program */
            tooltip = t.image;
      break;
    case T_SYSTEM:
      t = jj_consume_token(T_SYSTEM);
            /* Ensure that there are no duplicate tooltip ("tip") tokens */
            if (systemTokenParsed) {
                {if (true) throw new ParseException("Duplicate \u005c"system\u005c" field on line: " + t.beginLine);}
            }
            systemTokenParsed = true;

            /* default to no system supported, and loop until the current operating system
             * matches an operating system in the PCD file's "system" list
             */
            systemSupported = false;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NL:
        label_3:
        while (true) {
          jj_consume_token(NL);
          assertIndent(1);
          SystemName();
          jj_consume_token(NL);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case NL:
            ;
            break;
          default:
            jj_la1[4] = jj_gen;
            break label_3;
          }
        }
        break;
      case T_LINUX:
      case T_OSX:
      case T_SOLARIS:
      case T_UNIX:
      case T_WINDOWS:
      case T_ALL:
        SystemName();
        jj_consume_token(NL);
        break;
      default:
        jj_la1[5] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[6] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
 * Parses a list of supported operating systems in a PCD file
 **
 * The list is then compared with the current operating system
 * to see if it is supported by the PCD command.
 **
 * Currently supported operating systems:
 * ALL     (the command supports any operating system)
 * Linux
 * OSX
 * Solaris
 * Unix    (the command will only work in UNIX-compatible systems)
 * Windows (the command will only work in Windows-compatible systems)
 **
 * @return whether the current operating system is supported by the PCD command
 */
  final public void SystemName() throws ParseException {
    /* Stores the status of whether the current operating system is
     * supported by the software represented in the PCD file */
    boolean osSupported = true;

    /* Stores the status of whether the current machine architecture is
     * supported by the software represented in the PCD file */
    boolean archSupported = true;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_ALL:
      jj_consume_token(T_ALL);
                    osSupported = true;
      break;
    case T_LINUX:
      jj_consume_token(T_LINUX);
                    osSupported = (   BLMain.CURRENT_OS == BLMain.OS.LINUX );
      break;
    case T_OSX:
      jj_consume_token(T_OSX);
                    osSupported = (   BLMain.CURRENT_OS == BLMain.OS.OSX );
      break;
    case T_SOLARIS:
      jj_consume_token(T_SOLARIS);
                    osSupported = (   BLMain.CURRENT_OS == BLMain.OS.SOLARIS );
      break;
    case T_UNIX:
      jj_consume_token(T_UNIX);
                    osSupported = ( ! BLMain.CURRENT_OS.isWindows() );
      break;
    case T_WINDOWS:
      jj_consume_token(T_WINDOWS);
                    osSupported = (   BLMain.CURRENT_OS.isWindows() );
      break;
    default:
      jj_la1[7] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_X86:
    case T_AMD64:
    case T_SPARC:
    case T_ALL:
      archSupported = ArchList();
      break;
    default:
      jj_la1[8] = jj_gen;
      ;
    }
      systemSupported = systemSupported || ( archSupported && osSupported );
  }

/**
 * Parses a list of supported system architectures in a PCD file
 **
 * The list is then compared with the current system architecture
 * to see if it is supported by the PCD command.
 **
 * @return whether the current system architecture is supported by the PCD command
 */
  final public boolean ArchList() throws ParseException {
    /* Stores the status of the current architecture tested */
    boolean temp = false;

    /* Stores the status of the entire list */
    boolean archSupport = false;
    /* match each system architecture token and determine whether or not
         * the system architecture matches the current architecture */
        archSupport = ArchName();
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[9] = jj_gen;
        break label_4;
      }
      jj_consume_token(COMMA);
      /* get the system architecture name */
              temp = ArchName();
          archSupport = archSupport || temp;
    }
      {if (true) return archSupport;}
    throw new Error("Missing return statement in function");
  }

/**
 * Matches an architecture name and returns whether it is supported by
 * the current architecture.
 **
 * Currently supported machine architectures:
 * ALL     (the command supports any machine architecture
            - may be useful for shell-scripts)
 * X86     (any x86 compatible machine)
 * AMD64   (any amd64 compatible machine)
 * Sparc   (any amd64 compatible machine)
 **
 * @return whether the architecture is supported
 */
  final public boolean ArchName() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_ALL:
      jj_consume_token(T_ALL);
                   {if (true) return true;}
      break;
    case T_X86:
      jj_consume_token(T_X86);
                   {if (true) return (BLMain.CURRENT_ARCH == BLMain.ARCH.X86 ||
                           BLMain.CURRENT_ARCH == BLMain.ARCH.AMD64);}
      break;
    case T_AMD64:
      jj_consume_token(T_AMD64);
                   {if (true) return (BLMain.CURRENT_ARCH == BLMain.ARCH.AMD64);}
      break;
    case T_SPARC:
      jj_consume_token(T_SPARC);
                   {if (true) return (BLMain.CURRENT_ARCH == BLMain.ARCH.SPARC);}
      break;
    default:
      jj_la1[10] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

//////////////////////////////
/****************************/
/*                          */
/* BBB    OOO   DDD   Y   Y */
/* B  B  O   O  D  D  Y   Y */
/* BBB   O   O  D  D   YYY  */
/* B  B  O   O  D  D    Y   */
/* BBB    OOO   DDD     Y   */
/*                          */
/****************************/
//////////////////////////////


/**
 * Generates a tabbed pane based on reading the tab tag from the PCD file.
 **
 * This function reads the <T_TAB> tag, parses the name, and creates a
 * new panel object that all sub-components can be added to.  The tab
 * is then added to a tabbed pane in the main window.
 *
 * Each tab can only contain paramter objects,
 * and each tab MUST contain at least one parameter object.
 */
  final public void Tab(int scope, WidgetContainer wcontainer) throws ParseException {
    /* The panel to add parameters to */
    TabWidget tabw = new TabWidget();

    /* The name of the current tab */
    String tabName = "";

    /* The widget list storing the content of the tab*/
    LinkedList<Widget> widgetList = new LinkedList<Widget>();
    label_5:
    while (true) {
      jj_consume_token(T_TAB);
                  tabName = Text();
      jj_consume_token(NL);
      label_6:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case T_PARAM:
          Param(scope + 1, tabw);
          break;
        default:
          jj_la1[11] = jj_gen;
          if (jj_2_4(1)) {
            Tab(scope + 1, tabw);
          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        if (testIndent(scope + 1)) {
          ;
        } else {
          break label_6;
        }
      }
      if (testIndent(scope)) {
        ;
      } else {
        break label_5;
      }
    }
      wcontainer.addWidget(name, tabw);
  }

/**
 * Generates a parameter component according to the PCD file's
 * <T_PARAM> production(s).
 **
 * This function reads the <T_PARAM> tag, parses the name, and creates a
 * new parameter component corresponding to the type of parameter read.
 *
 * Each parameter MUST contain a type as its first field!
 *
 * Currently the following types are supported:
 * <table>
 *  <tr> <th>Type field</th> <th>Description</th> </tr>
 *  <tr> <td>button</td>     <td>Buttons which can run commands or perform
                                 functions</td> </tr>
 *  <tr> <td>list</td>       <td>A JList containing options</td> </tr>
 *  <tr> <td>chooser</td>    <td>A radio button field</td> </tr>
 *  <tr> <td>text</td>       <td>A text-field</td> </tr>
 *  <tr> <td>number</td>     <td>A slider/spinner combination to set numbers</td> </tr>
 *  <tr> <td>decimal</td>    <td>A decimal number widget</td> </tr>
 *  <tr> <td>file</td>       <td>A file used for I/O</td> </tr>
 * </table>
 **
 * @param scope the scope to parse the parameter object in
 * @return the corresponding Widget
 */
  final public void Param(int scope, WidgetContainer wcontainer) throws ParseException {
    /* The name of the parameter (for variable reference) */
    String name;

    /* Temporarily stores parameters before they are returned */
    Widget parameter = null;
    assertIndent(scope);
    jj_consume_token(T_PARAM);
    name = Text();
    jj_consume_token(NL);
    assertIndent(scope + 1);
    jj_consume_token(T_TYPE);
    inorsp(scope + 2);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_BUTTON:
      jj_consume_token(T_BUTTON);
      jj_consume_token(NL);
      parameter = buttonFields(scope + 1);
      break;
    case T_LIST:
      jj_consume_token(T_LIST);
      jj_consume_token(NL);
      parameter = listFields(scope + 1);
      break;
    case T_CHOOSER:
      jj_consume_token(T_CHOOSER);
      jj_consume_token(NL);
      parameter = chooserFields(scope + 1);
      break;
    case T_COMBOBOX:
      jj_consume_token(T_COMBOBOX);
      jj_consume_token(NL);
      parameter = comboFields(scope + 1);
      break;
    case T_TEXT:
      jj_consume_token(T_TEXT);
      jj_consume_token(NL);
      parameter = textFields(scope + 1);
      break;
    case T_NUMBER:
      jj_consume_token(T_NUMBER);
      jj_consume_token(NL);
      parameter = numberFields(scope + 1);
      break;
    case T_DECIMAL:
      jj_consume_token(T_DECIMAL);
      jj_consume_token(NL);
      parameter = decimalFields(scope + 1);
      break;
    case T_TEMPFILE:
      jj_consume_token(T_TEMPFILE);
      jj_consume_token(NL);
      parameter = tempfileFields(scope + 1);
      break;
    default:
      jj_la1[12] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      wcontainer.addWidget(name, parameter);
  }

/**
 * Parses all of the fields that should be part of any button field
 **
 * @param scope the scope level to read the objects at
 */
  final public Widget buttonFields(int scope) throws ParseException {
    /* the label for the field */
    String label = "";
    /* the shell command to run */
    String shell = "";
    /* whether to close the window after running the command */
    boolean close = false;
    assertIndent(scope);
    jj_consume_token(T_LABEL);
    inorsp(scope + 1);
    label = Text();
    jj_consume_token(NL);
    assertIndent(scope);
    jj_consume_token(T_SHELL);
    inorsp(scope + 1);
    shell = Text();
    jj_consume_token(NL);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_CLOSE:
      assertIndent(scope);
      jj_consume_token(T_CLOSE);
      inorsp(scope + 1);
      close = Bool();
      jj_consume_token(NL);
      break;
    default:
      jj_la1[13] = jj_gen;
      ;
    }
      {if (true) return new CommandButton(label, shell, close);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses all of the fields that should be part of any chooser object
 **
 * @param scope the scope level to read the objects at
 */
  final public Widget chooserFields(int scope) throws ParseException {
    /* the label for the field */
    String label = "";
    /* The default for the text field */
    String value = "";
    /* The name  of the current choice to add to the choices hashtable */
    String choiceName;
    /* The value of the current choice to add to the choices hashtable */
    String choiceValue;
    /**
     * The list of choices
     */
    Map<String,String> choices = new OrderedHash<String,String>();
      assertIndent(scope);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_LABEL:
      jj_consume_token(T_LABEL);
                      inorsp(scope + 1); label = Text();
      jj_consume_token(NL);
                                                                  assertIndent(scope);
      break;
    default:
      jj_la1[14] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_DEFAULT:
      jj_consume_token(T_DEFAULT);
                      inorsp(scope + 1); value = Text();
      jj_consume_token(NL);
                                                                  assertIndent(scope);
      break;
    default:
      jj_la1[15] = jj_gen;
      ;
    }
    jj_consume_token(T_CHOICES);
    jj_consume_token(NL);
    label_7:
    while (true) {
                  choiceName  = Text();
      jj_consume_token(NL);
                  assertIndent(scope + 2);
                  choiceValue = Text();
      jj_consume_token(NL);
                      choices.put(choiceName, choiceValue);
      if (testIndent(scope + 1)) {
        ;
      } else {
        break label_7;
      }
    }
      {if (true) return new Chooser(label, choices, value);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses all of the fields that should be part of any combobox object
 **
 * @param scope the scope level to read the objects at
 */
  final public Widget comboFields(int scope) throws ParseException {
    /* the label for the field */
    String label = "";
    /* The default for the text field */
    String value = "";
    /* The name  of the current choice to add to the choices hashtable */
    String choiceName;
    /* The value of the current choice to add to the choices hashtable */
    String choiceValue;
    /**
     * The list of choices
     */
    Map<String,String> choices = new OrderedHash<String,String>();
      assertIndent(scope);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_LABEL:
      jj_consume_token(T_LABEL);
                      inorsp(scope + 1); label = Text();
      jj_consume_token(NL);
                                                                  assertIndent(scope);
      break;
    default:
      jj_la1[16] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_DEFAULT:
      jj_consume_token(T_DEFAULT);
                      inorsp(scope + 1); value = Text();
      jj_consume_token(NL);
                                                                  assertIndent(scope);
      break;
    default:
      jj_la1[17] = jj_gen;
      ;
    }
    jj_consume_token(T_CHOICES);
    jj_consume_token(NL);
    label_8:
    while (true) {
                  choiceName  = Text();
      jj_consume_token(NL);
                  assertIndent(scope + 2);
                  choiceValue = Text();
      jj_consume_token(NL);
                      choices.put(choiceName, choiceValue);
      if (testIndent(scope + 1)) {
        ;
      } else {
        break label_8;
      }
    }
      {if (true) return new ComboBoxWidget(label, choices, value);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses all of the fields that should be part of any list object
 **
 * @param scope the scope level to read the objects at
 */
  final public Widget listFields(int scope) throws ParseException {
    /* the label for the field */
    String label = "";
    /* The default for the text field */
    String value = "";
    /* The name  of the current choice to add to the choices hashtable */
    String choiceName;
    /* The value of the current choice to add to the choices hashtable */
    String choiceValue;
    /**
     * The list of choices
     */
    Map<String,String> choices = new OrderedHash();
      assertIndent(scope);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_LABEL:
      jj_consume_token(T_LABEL);
                      inorsp(scope + 1); label = Text();
      jj_consume_token(NL);
                                                                  assertIndent(scope);
      break;
    default:
      jj_la1[18] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_DEFAULT:
      jj_consume_token(T_DEFAULT);
                      inorsp(scope + 1); value = Text();
      jj_consume_token(NL);
                                                                  assertIndent(scope);
      break;
    default:
      jj_la1[19] = jj_gen;
      ;
    }
    jj_consume_token(T_CHOICES);
    jj_consume_token(NL);
    label_9:
    while (true) {
                  choiceName  = Text();
      jj_consume_token(NL);
                  assertIndent(scope + 2);
                  choiceValue = Text();
      jj_consume_token(NL);
                      choices.put(choiceName, choiceValue);
      if (testIndent(scope + 1)) {
        ;
      } else {
        break label_9;
      }
    }
      {if (true) return new ChoiceList(label, choices, value);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses all of the fields that should be part of any text field
 **
 * @param scope the scope level to read the objects at
 */
  final public Widget textFields(int scope) throws ParseException {
    /* the label for the field */
    String label = "";
    /* The default for the text field */
    String value = "";
    if (jj_2_5(2147483647)) {
                               assertIndent(scope);
      jj_consume_token(T_LABEL);
      inorsp(scope + 1);
      label = Text();
      jj_consume_token(NL);
    } else {
      ;
    }
    if (jj_2_6(2147483647)) {
                               assertIndent(scope);
      jj_consume_token(T_DEFAULT);
      inorsp(scope + 1);
      Text();
      jj_consume_token(NL);
    } else {
      ;
    }
      {if (true) return new TextWidget(label, value);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses all of the fields that should be part of any number field
 **
 * @param scope the scope level to read the objects at
 */
  final public Widget numberFields(int scope) throws ParseException {
    /* the label for the field */
    String label = "";
    /* The minimum number allowed */
    int min;
    /* The maximum number allowed */
    int max;
    /* The default for the number field */
    int value;
    /* The token to use for error reporting information */
    Token current;
    assertIndent(scope);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_LABEL:
      jj_consume_token(T_LABEL);
      inorsp(scope + 1);
      label = Text();
      jj_consume_token(NL);
      assertIndent(scope);
      break;
    default:
      jj_la1[20] = jj_gen;
      ;
    }
    jj_consume_token(T_MIN);
    inorsp(scope + 1);
    min = Number();
    jj_consume_token(NL);
    assertIndent(scope);
    current = jj_consume_token(T_MAX);
    inorsp(scope + 1);
    max = Number();
    jj_consume_token(NL);
        if (min > max) {
            {if (true) throw new ParseException("Field 'min' is greater than field 'max' on line: " + current.endLine);}
        }
      value = min;
    if (jj_2_7(2147483647)) {
                               assertIndent(scope);
      current = jj_consume_token(T_DEFAULT);
      inorsp(scope + 1);
      value = Number();
      jj_consume_token(NL);
            if (value > max) {
                {if (true) throw new ParseException("The default value is greater than the maximum value on line: " + current.endLine);}
            } else if (value < min) {
                {if (true) throw new ParseException("The default value is less than the minimum value on line: " + current.endLine);}
            }
    } else {
      ;
    }
      {if (true) return new NumberWidget(label, min, max, value);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses all of the fields that should be part of any decimal field
 **
 * @param scope the scope level to read the objects at
 */
  final public Widget decimalFields(int scope) throws ParseException {
    /* the label for the field */
    String label = "";
    /* The minimum number allowed */
    double min;
    /* The maximum number allowed */
    double max;
    /* The default for the number field */
    double value;
    /* The token to use for error reporting information */
    Token current;
    assertIndent(scope);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_LABEL:
      jj_consume_token(T_LABEL);
      inorsp(scope + 1);
      label = Text();
      jj_consume_token(NL);
      assertIndent(scope);
      break;
    default:
      jj_la1[21] = jj_gen;
      ;
    }
    jj_consume_token(T_MIN);
    inorsp(scope + 1);
    min = Decimal();
    jj_consume_token(NL);
    assertIndent(scope);
    current = jj_consume_token(T_MAX);
    inorsp(scope + 1);
    max = Decimal();
    jj_consume_token(NL);
        if (min > max) {
            {if (true) throw new ParseException("Field 'min' is greater than field 'max' on line: " + current.endLine);}
        }
      value = min;
    if (jj_2_8(2147483647)) {
                               assertIndent(scope);
      current = jj_consume_token(T_DEFAULT);
      inorsp(scope + 1);
      value = Decimal();
      jj_consume_token(NL);
            if (value > max) {
                {if (true) throw new ParseException("The default value is greater than the maximum value on line: " + current.endLine);}
            } else if (value < min) {
                {if (true) throw new ParseException("The default value is less than the minimum value on line: " + current.endLine);}
            }
    } else {
      ;
    }
      {if (true) return new DecimalWidget(label, min, max, value);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses all of the fields that should be part of any temporary file field
 **
 * @param scope the scope level to read the objects at
 */
  final public Widget tempfileFields(int scope) throws ParseException {
    /* Whether or not to add the contents of the window to the file before execution
     * (whether the temporary file is input for a program). */
    String input = null;
    /* Whether or not to add the contents of the file to the window after execution.
     * (whether the temporary file is output for a program). */
    String output = null;
    /* Determines whether or not to delete the file after execution. */
    boolean save = false;
    /* Determines whether or not to overwrite the file if it already exists. */
    boolean overwrite = false;
    /* Stores the file format of the file (used for translation). */
    String format = null;
    if (jj_2_9(2147483647)) {
                                 assertIndent(scope);
      jj_consume_token(T_IN);
                                                                        inorsp(scope + 1); input=Text();
      jj_consume_token(NL);
    } else {
      ;
    }
    if (jj_2_10(2147483647)) {
                                 assertIndent(scope);
      jj_consume_token(T_OUT);
                                                                        inorsp(scope + 1); output=Text();
      jj_consume_token(NL);
    } else {
      ;
    }
    if (jj_2_11(2147483647)) {
                                 assertIndent(scope);
      jj_consume_token(T_SAVE);
                                                                        inorsp(scope + 1); save=Bool();
      jj_consume_token(NL);
    } else {
      ;
    }
    if (jj_2_12(2147483647)) {
                                 assertIndent(scope);
      jj_consume_token(T_OVERWRITE);
                                                                        inorsp(scope + 1); overwrite=Bool();
      jj_consume_token(NL);
    } else {
      ;
    }
    if (jj_2_13(2147483647)) {
                                 assertIndent(scope);
      jj_consume_token(T_FORMAT);
                                                                        inorsp(scope + 1); format=Text();
      jj_consume_token(NL);
    } else {
      ;
    }
    if (jj_2_14(2147483647)) {
                                 assertIndent(scope);
      jj_consume_token(T_CONTENT);
                                                                        inorsp(scope + 1); ContentValue();
      jj_consume_token(NL);
    } else {
      ;
    }
      {if (true) return new TempFile("selection".equalsIgnoreCase(input), "newseq".equalsIgnoreCase(output), save, overwrite, format);}
    throw new Error("Missing return statement in function");
  }

  final public void ContentValue() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_CANVAS:
      jj_consume_token(T_CANVAS);
      break;
    case T_SELECTION:
      jj_consume_token(T_SELECTION);
      break;
    default:
      jj_la1[22] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

////////////////////////////////////////
/**************************************/
/*                                    */
/* H  H  EEEE  L     PPP   EEEE  RRR  */
/* H  H  E     L     P  P  E     R  R */
/* HHHH  EEEE  L     PPP   EEEE  RRR  */
/* H  H  E     L     P     E     R  R */
/* H  H  EEEE  LLLL  P     EEEE  R  R */
/*                                    */
/**************************************/
////////////////////////////////////////


/**
 * Parses an identifier token from a PCD file into a Java String
 **
 * @return the coresponding Java String object
 */
  final public String Ident() throws ParseException {
    /* The token to parse into a String value */
    Token t = null;
    /* Match a text token */
        t = jj_consume_token(ID);
      {if (true) return t.image;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a text token from a PCD file into a Java String
 **
 * @return the coresponding Java String object
 */
  final public String Text() throws ParseException {
    /* The token to parse into a String value */
    Token t = null;
    /* Match a text token */
        t = jj_consume_token(TEXT);
      {if (true) return t.image.substring(1, t.image.length() - 1);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a decimal number from a PCD file into a Java double
 **
 * @return the coresponding Java double value
 */
  final public double Decimal() throws ParseException {
    /* The double value parsed by the function */
    double value = 0d;

    /* The token to parse into a double value */
    Token t = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DECIMAL:
      t = jj_consume_token(DECIMAL);
            try {
                value = Double.parseDouble(t.image);
            } catch (NumberFormatException nfe) {
                /* NOTE: this statement should never be reached because the
	         *       token manager will only pass proper decimal numbers
		 *       to this code; however, Java requires a try-catch
		 *       clause in order to parse Strings into doubles */
                {if (true) throw new ParseException("Invalid decimal number on line: " +
                    t.endLine);}
            }
      break;
    case NUMBER:
      value = Number();
      break;
    default:
      jj_la1[23] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return value;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a non-decimal number from a PCD file into a Java integer
 **
 * @return the coresponding Java int value
 */
  final public int Number() throws ParseException {
    /* The integer value parsed by the function */
    int value = 0;

    /* The token to parse into an integer value */
    Token t = null;
    /* Match the number token to parse */
            t = jj_consume_token(NUMBER);
            try {
                value = Integer.parseInt(t.image);
            } catch (NumberFormatException nfe) {
                /* NOTE: this statement should never be reached because the
                 *       token manager will only pass proper numbers to this
                 *       code; however, Java requires a try-catch clause in
                 *       order to parse Strings into integers */
                {if (true) throw new ParseException("Invalid number on line: " +
                    t.endLine);}
            }
      {if (true) return value;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a boolean token into a java boolean
 **
 * @return the value of the boolean
 */
  final public boolean Bool() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_TRUE:
      jj_consume_token(T_TRUE);
                  {if (true) return true;}
      break;
    case T_FALSE:
      jj_consume_token(T_FALSE);
                  {if (true) return false;}
      break;
    default:
      jj_la1[24] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses an optional indent (this is useful for values that can be spaced
 * or indented onto a new line (e.g. type can be represented as:
 **
 *     type slider
 *     - OR -
 *     type
 *         slider
 **
 * @param scope the number of indents to consume if we match a new line token
 */
  final public void inorsp(int scope) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NL:
      jj_consume_token(NL);
      assertIndent(scope);
      break;
    default:
      jj_la1[25] = jj_gen;
      ;
    }
  }

/**
 * Asserts indentation level (calls token_source.testIndent)
 **
 * @param scope the number of indents required
 */
  final public void assertIndent(int scope) throws ParseException {
        if (!testIndent(scope)) {
            {if (true) throw new ParseException("Indentation error on line: "
                + getToken(1).beginLine + " with an indentation of "
                + (token_source.getIndent() * token_source.INDENT_SIZE)
                + " spaces (expected "
                + (scope * token_source.INDENT_SIZE) + " spaces)");}
        }
  }

/**
 * Tests indentation (NOTE: this calls the token manager)
 **
 * @param scope the number of indents required
 */
  final public boolean testIndent(int scope) throws ParseException {
      getToken(1);
      {if (true) return (token_source.getIndent() == scope);}
    throw new Error("Missing return statement in function");
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_3R_12() {
    if (jj_scan_token(T_TAB)) return true;
    return false;
  }

  private boolean jj_3R_13() {
    if (jj_3R_14()) return true;
    if (jj_scan_token(T_PARAM)) return true;
    return false;
  }

  private boolean jj_3_3() {
    Token xsp;
    if (jj_3_2()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_2()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_10() {
    Token xsp;
    if (jj_3R_12()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_12()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_6() {
    if (jj_scan_token(T_DEFAULT)) return true;
    return false;
  }

  private boolean jj_3_5() {
    if (jj_scan_token(T_LABEL)) return true;
    return false;
  }

  private boolean jj_3_8() {
    if (jj_scan_token(T_DEFAULT)) return true;
    return false;
  }

  private boolean jj_3_14() {
    if (jj_scan_token(T_CONTENT)) return true;
    return false;
  }

  private boolean jj_3_7() {
    if (jj_scan_token(T_DEFAULT)) return true;
    return false;
  }

  private boolean jj_3_13() {
    if (jj_scan_token(T_FORMAT)) return true;
    return false;
  }

  private boolean jj_3_12() {
    if (jj_scan_token(T_OVERWRITE)) return true;
    return false;
  }

  private boolean jj_3_11() {
    if (jj_scan_token(T_SAVE)) return true;
    return false;
  }

  private boolean jj_3_10() {
    if (jj_scan_token(T_OUT)) return true;
    return false;
  }

  private boolean jj_3_9() {
    if (jj_scan_token(T_IN)) return true;
    return false;
  }

  private boolean jj_3_4() {
    if (jj_3R_10()) return true;
    return false;
  }

  private boolean jj_3R_14() {
    return false;
  }

  private boolean jj_3_1() {
    if (jj_3R_10()) return true;
    return false;
  }

  private boolean jj_3_2() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_11()) {
    jj_scanpos = xsp;
    if (jj_3_1()) return true;
    }
    return false;
  }

  private boolean jj_3R_11() {
    if (jj_3R_13()) return true;
    return false;
  }

  /** Generated Token Manager. */
  public PCDFileTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[26];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x0,0x0,0x0,0x0,0x0,0x7c00,0x0,0x7c00,0x38000,0x0,0x38000,0x0,0x3de,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0000,0x0,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x8000000,0x801c0,0x100000,0x20,0x8000000,0x8010000,0x801c0,0x10000,0x10000,0x400000,0x10000,0x100000,0x0,0x0,0x40000,0x20000,0x40000,0x20000,0x40000,0x20000,0x40000,0x40000,0x600,0x3000000,0x0,0x8000000,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[14];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public PCDFile(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public PCDFile(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new PCDFileTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 26; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 26; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public PCDFile(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new PCDFileTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 26; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 26; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public PCDFile(PCDFileTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 26; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(PCDFileTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 26; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[69];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 26; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 69; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 14; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
