
package org.biolegato.core.pcdmenu.widgets;

import java.awt.Component;
import java.util.Map;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import org.biolegato.core.pcdmenu.*;

/**
 * A wrapper class used to abstract choice lists within command windows.
 **
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class ChoiceList extends ListWidget {
    /**
     * The combobox contianing the data.
     */
    protected JList choice_list = null;
    /**
     * Used for serialization purposes.
     */
    private static final long serialVersionUID = 7526472295622776158L;
    
    /**
     * Creates a new instance of GDEComboBox (represents "choice_list" in GDE menu files).
     **
     * @param data the data to create the combobox with.
     */
    public ChoiceList(String label, Map<String,String> choices, String value) {
        super(label, choices, value);
    }
    
    /**
     * Returns the name of this type of variable.
     **
     * @return the name of the variable type "choice_list".
     */
    public static String getType() {
        return "choice_list";
    }
    
    /**
     * This function is used to maintain user variable settings from window to window.
     * Each time a runwindow is closed, this function is called to ensure that the next time
     * the user opens the runwindow, the value of this variable will default to the same
     * value the user picked the last time the runwindow was open.
     **
     * @return the new default value for the variable
     */
    public Object getNewDefault() {
        return choice_list.getSelectedValue();
    }
    /**
     * Returns the value of the variable.
     **
     * @return the current value of the widget.
     */
    public Object getValue() {
        return choices.get(choice_list.getSelectedValue().toString());
    }
    /**
     * Displays the choice list
     **
     * @return the choice list widget
     */
    public Component display() {
        int defaultEntry = 0;
        String[] orderChoices = null;         // used for default values
        
        // a combo box which returns its value when toString is called
        choice_list = new JList(choices.keySet().toArray());
        
        // handle the default value for the list
        if (value != null) {
            for (Map.Entry<String, String> e : choices.entrySet()) {
                if (e.getValue().toString().equalsIgnoreCase(value)) {
                    choice_list.setSelectedValue(e.getKey(), true);
                }
            }
        }
        
        // make the choice_list only support single selection
        choice_list.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        
        // add the choice list (and make it scrollable)
        return new JScrollPane(choice_list, JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED, JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
    }
    /**
     * Closes the open object
     */
    public void close() {
    }
}
