package org.biolegato.core.pcdmenu.widgets;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.biolegato.core.pcdmenu.*;

/**
 * Wrapper class for a group of radiobuttons.
 **
 * NOTE: This can be added to any JContainer since it extends JPanel.
 **
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class Chooser extends ListWidget implements ActionListener {
    /**
     * Required for serialization purposes.
     */
    private static final long serialVersionUID = 7526472295622776152L;
    
    /**
     * Creates a new instance of EZChooser.
     *
     * @param data The value/name list of each of the radiobuttons
     */
    public Chooser(String label, Map<String,String> choices, String value) {
        super(label, choices, value);
    }
    
    /**
     * Handles selection changes of the radio buttons.
     *
     * @param e used to determine which button is selected (by use of getActionCommand()).
     */
    public void actionPerformed(ActionEvent e) {
        value = e.getActionCommand();
    }
    
    /**
     * Returns the name of this type of variable.
     *
     * @return "chooser" - the name of the variable type.
     */
    public static String getType() {
        return "chooser";
    }
    
    /**
     * This function is used to maintain user variable settings from window to window.
     * Each time a runwindow is closed, this function is called to ensure that the next time
     * the user opens the runwindow, the value of this variable will default to the same
     * value the user picked the last time the runwindow was open.
     *
     * @return the new default value for the variable
     */
    public Object getNewDefault() {
        return value;
    }
    /**
     * Returns the value of the variable.
     *
     * @return the current value of the variable
     */
    public Object getValue() {
        return (choices != null ? choices.get(value) : "");
    }
    
    public Component display() {
        Box result = new Box(BoxLayout.LINE_AXIS);
        String[] entries = null;
        ButtonGroup group = new ButtonGroup();
        JPanel panel = new JPanel();
        JRadioButton radio;
        
        if (label != null) {
            result.add(new JLabel(label));
        }
        
        for (String entry : choices.keySet()) {
            radio = new JRadioButton(entry);
            panel.add(radio);
            radio.setActionCommand(entry);
            radio.addActionListener(this);
            if (entry.equalsIgnoreCase(value)) {
                radio.setSelected(true);
            }
            group.add(radio);
        }
        result.add(panel);
        
        return result;
    }
    
    public void close() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}
