/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.biolegato.core.pcdmenu.widgets;

import java.awt.Component;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneConstants;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import org.biolegato.core.main.BLMain;
import org.biolegato.core.pcdmenu.*;

/**
 * A wrapper class used to abstract combo boxes within command windows.
 **
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class ComboBoxWidget extends ListWidget {
    /**
     * The combobox contianing the data
     */
    protected JComboBox combobox = null;
    /**
     * The UI to enable scrolling of the JComboBox.
     */
    public final BasicComboBoxUI comboboxUI = new BasicComboBoxUI() {
        @Override
                protected ComboPopup createPopup() {
            BasicComboPopup uipopup = new BasicComboPopup(comboBox){
                @Override
                        protected JScrollPane createScroller() {
                    return new JScrollPane( list, ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED,
                            ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED );
                }
            };
            return uipopup;
        }
    };
    /**
     * used for serialization
     */
    private static final long serialVersionUID = 7526472295622776158L;
    
    /**
     * Creates a new instance of EZComboBox (represents "choice_list" in GDE menu files).
     *
     * @param data the data to create the combobox with.
     */
    public ComboBoxWidget(String label, Map<String,String> choices, String value) {
        super(label, choices, value);
    }
    
    public Component display() {
        Box result = new Box(BoxLayout.LINE_AXIS);
        int defaultEntry = 0;
        String[] orderChoices = null;         // used for default values
        
        // a combo box which returns its value when toString is called
        if (label != null) {
            result.add(new JLabel(label));
        }
        
        combobox = new JComboBox(choices.keySet().toArray());
        
        // handle the default value for the list
        if (value != null) {
            for (Map.Entry<String, String> e : choices.entrySet()) {
                if (e.getValue().equalsIgnoreCase((String) value)) {
                    combobox.setSelectedItem(e.getKey());
                }
            }
        } else {
            BLMain.error("Invalid argument (missing choice list)", "BLComboBox");
        }
        combobox.setUI(comboboxUI);
        combobox.updateUI();
        
        return combobox;
    }
    /**
     * Returns the name of this type of variable.
     *
     * @return "choice_menu" - the name of the variable type
     */
    public static String getType() {
        return "choice_menu";
    }
    
    /**
     * This function is used to maintain user variable settings from window to window.
     * Each time a runwindow is closed, this function is called to ensure that the next time
     * the user opens the runwindow, the value of this variable will default to the same
     * value the user picked the last time the runwindow was open.
     *
     * @return the new default value for the variable
     */
    public Object getNewDefault() {
        return combobox.getSelectedItem();
    }
    
    /**
     * Returns the value of the variable.
     *
     * @return the value of the variable.
     */
    public Object getValue() {
        return choices.get(combobox.getSelectedItem().toString());
    }
    
    public void close() {
        combobox = null;
    }
}
