package org.biolegato.core.pcdmenu.widgets;

import java.awt.Component;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.biolegato.core.pcdmenu.*;

/**
 * Wraps a widget(s) for selecting numeric values.
 **
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class DecimalWidget implements Widget, ChangeListener {
    /**
     * The minimum number allowed
     */
    private double min;
    /**
     * The maximum number allowed
     */
    private double max;
    /**
     * The default for the decimal field
     */
    private double value;
    /**
     * The label for the widget
     */
    private String label = null;
    /**
     * The spinner portion of the number selector widget.
     */
    private JSpinner spinner = null;
    /**
     * Used for serialization purposes.
     */
    private static final long serialVersionUID = 7526472295622776161L;

    /**
     * Creates a new instance of DecimalWidget
     * 
     * @param data the map containing all of the information required to make the number selector.
     */
    public DecimalWidget (String label, double min, double max, double value) {
        this.label = label;
        this.min   = min;
        this.max   = max;
        this.value = value;
    }

    /**
     * Receives the new value on spinner changes
     * 
     * @param e used to determine which widget was changed.
     */
    public void stateChanged (ChangeEvent e) {
        value = ((Number) spinner.getValue()).intValue();
    }

    /**
     * Returns the name of this type of variable.
     *
     * @return the name of the variable type -- "slider".
     */
    public static String getType () {
        return "slider";
    }

    public Component display() {
        Box container = new Box(BoxLayout.LINE_AXIS);

        if (spinner == null) {
            // create the spinner
            spinner = new JSpinner(new SpinnerNumberModel(value, min, max, 1));
            spinner.addChangeListener(this);

            // add the spinner
            container.add(spinner);
            container.add(new JLabel("" + min));
        }

        // add the slider
        container.add(new JLabel("" + max));
        
        return container;
    }

    public void close() {
        spinner = null;
    }

    /**
     * Returns the current value of the variable.
     *
     * @return the value selected by the spinner.
     */
    public Object getValue () {
        return value;
    }
}
