package org.biolegato.core.pcdmenu.widgets;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import org.biolegato.core.main.BLMain;
import org.biolegato.core.pcdmenu.*;

/**
 * A wrapper class used to abstract file selection within command windows.
 **
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class FileChooser extends TextWidget implements ActionListener {
    
    /**
     * Creates a new instance of GDETempFile.
     *
     * @param data the data to create the temporary file variable with.
     */
    public FileChooser(String label, String value) {
        super(label, value);
    }

    /**
     * Handle the choose file button
     *
     * @param e ignored because there is only one widget calling this method.
     */
    public void actionPerformed(ActionEvent e) {
        JFileChooser openDialog = new JFileChooser();
        openDialog.setCurrentDirectory(BLMain.getCurrentPWD());
        openDialog.setAcceptAllFileFilterUsed(true);

        // if a file is selected, open it
        if (openDialog.showOpenDialog(BLMain.getJFrame()) == JFileChooser.APPROVE_OPTION) {
            textfield.setText("\"" + openDialog.getSelectedFile().getPath() + "\"");
	    if (openDialog.getCurrentDirectory() != null) {
		BLMain.setCurrentPWD(openDialog.getCurrentDirectory());
	    }
        }
    }

    @Override
    public Component display () {
        Box result = new Box(BoxLayout.LINE_AXIS);
        JButton pickFile = new JButton("Choose file...");

        pickFile.addActionListener(this);

        result.add(super.display());
        result.add(pickFile);
        
        return result;
    }
}
