package org.biolegato.core.pcdmenu.widgets;

import java.util.Map;
import org.biolegato.core.pcdmenu.*;

/**
 * A wrapper class used to abstract combo boxes within command windows.
 **
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public abstract class ListWidget implements Widget {
    /**
     * Stores the current value selected by the chooser.
     */
    protected String value = "";
    /**
     * The label to associate with the list widget
     */
    protected String label = null;
    /**
     * The list of choices
     */
    protected Map<String,String> choices = null;
    /**
     * used for serialization
     */
    private static final long serialVersionUID = 7526472295622776158L;


    /**
     * Creates a new instance of EZComboBox (represents "choice_list" in GDE menu files).
     *
     * @param data the data to create the combobox with.
     */
    public ListWidget(String label, Map<String,String> choices, String value) {
        this.label = label;
        this.choices = choices;
        this.value = value;
    }
}