package org.biolegato.core.pcdmenu.widgets;

import java.awt.Component;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.biolegato.core.pcdmenu.*;

/**
 * A wrapper class used to abstract text fields within command windows.
 **
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class TextWidget implements Widget {
    /* the label for the text field */
    private String label = null;
    /* the default value for the text field */
    private String value = null;
    /**
     * The textfield for obtaining the data
     */
    protected JTextField textfield = null;
    /**
     * Used for serialization purposes
     */
    private static final long serialVersionUID = 7526472295622776159L;


    /**
     * Creates a new instance of TextWidget
     **
     * @param scope the scope to parse for the productions
     */
    public TextWidget (String label, String value) {
        this.label = label;
        this.value = value;
    }

    public Component display () {
        Box result = new Box(BoxLayout.LINE_AXIS);

        /* creates the visible text field widget */
        if (label != null) {
            result.add(new JLabel(label));
        }
        textfield = new JTextField(20);
        if (value != null) {
            textfield.setText(value);
        }
        result.add(textfield);

        return result;
    }

    /**
     * Returns the value of the variable.
     **
     * @return the current value of the variable class.
     */
    public Object getValue () {
        return textfield.getText();
    }

    public void close () {
        textfield = null;
    }
}
