package org.biolegato.core.pcdmenu.widgets;

import java.awt.Component;


/**
 * Abstract interface to relate widget variables and invisible variables (such as temporary files)
 **
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public interface Widget {

    /**
     * Returns the value of the variable.
     **
     * @return the value of the variable
     */
    public Object getValue ();

    /**
     * Displays the current object
     */    
    public Component display();

    /**
     * Notifies the variable that the program has now completed successfully, and it can
     * perform any closing operations
     */
    public void close ();
}
