/*
 * ClipboardWrapper.java
 *
 * Created on November 25, 2010, 10:19 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.biolegato.gdesupport.canvas;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.biolegato.gdesupport.canvas.data.Cell;

/**
 *
 * @author alvare
 */
public class ClipboardWrapper implements Transferable{
///////////////////////
//*******************//
//* CLASS VARIABLES *//
//*******************//
///////////////////////
    /**
     * Stores the data to export
     */
    private Cell[] cellArray;
    /**
     * A data flavour representing the raw Cell data type.
     */
    public static final DataFlavor sequenceArrayFlavour = new DataFlavor(Cell[].class, "Raw BioLegato sequence");
    /**
     * An array to store all of the supported data falvours
     */
    public static final DataFlavor[] dataflavoursArray = new DataFlavor[]{sequenceArrayFlavour, DataFlavor.stringFlavor};
    
//////////////////////
//******************//
//* CONSTRUCTOR(S) *//
//******************//
//////////////////////
    /**
     * Creates a new instance of ClipboardWrapper
     **
     * @param cellArray the data to store in the wrapper
     */
    public ClipboardWrapper(Cell[] cellArray) {
        this.cellArray = cellArray;
    }

////////////////////
//****************//
//* TRANSFERABLE *//
//****************//
////////////////////
    /**
     * Dictates what formats the Dataset can be converted to.
     **
     * @return an array of supported formats
     */
    public DataFlavor[] getTransferDataFlavors() {
        return dataflavoursArray;
    }

    /**
     * Dictates whether a given format is supported for conversion
     **
     * @param flavour the flavour to test for compatability
     * @return true if the format is supported
     */
    public boolean isDataFlavorSupported(DataFlavor flavour) {
        boolean result = false;

        for (int count = 0; count < dataflavoursArray.length && !result; count++) {
            result = flavour.equals(dataflavoursArray[count]);
        }
        return result;
    }

    /**
     * Translates the Dataset to the given format
     **
     * @param flavour the data flavour to use for translation
     * @return the translated object
     * @throws UnsupportedFlavorException if the SeqDatasetnnot be translated into the requested data flavour
     * @throws IOException if there is a problem with I/O during the translation
     */
    public Object getTransferData(DataFlavor flavour) throws UnsupportedFlavorException, IOException {
        Object result = cellArray;

        if (!isDataFlavorSupported(flavour)) {
            throw new UnsupportedFlavorException(flavour);
        }
        if (DataFlavor.stringFlavor.equals(flavour)) {
            result = toString();
        }
        return result;
    }

//////////////////////
//******************//
//* DATA FUNCTIONS *//
//******************//
//////////////////////
    /**
     * Dumps the data contained within the clipboard wrapper
     **
     * @return the data contained within the wrapper
     */
    public Cell[] toArray () {
        return cellArray;
    }
}
