/*
 * GDECanvasObject.java
 *
 * Created on August 26, 2010, 11:30 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.biolegato.gdesupport.canvas;

import org.biolegato.gdesupport.canvas.data.Cell;

/**
 *
 * @author alvare
 */
public interface GDECanvasObject {

    /**
     * Copies content from the current Editable object.
     */
    public void copy();

    /**
     * Cuts content from the current Editable object.
     */
    public void cut();

    /**
     * Pastes content into the current Editable object.
     */
    public void paste();

    /**
     * Used to obtain all of the text selected within the document.
     *
     * @return the text currently selected in the document.
     */
    public Cell[] getData ();

    /**
     * Changes the case of the currently selected sequence
     * (if the sequence is of inconsistent case, the case of the entire sequence
     * is changed to the opposite case of the first character in the sequence.
     */
    public void changeCase ();
}
