/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.biolegato.gdesupport.canvas;

import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.biolegato.core.properties.BLProperties;

/**
 * A class for adding GDE canvas specific properties to.
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class GDECanvasProperties extends JDialog {
    /**
     * The BLProperties object to associate the properties extension with.
     */
    private final BLProperties properties;
    /**
     * Used for serialization purposes
     */
    private static final long serialVersionUID = 7526472295622777011L;

    /**
     * Creates a new GDECanvasProperties object.
     *
     * @param properties BioLegato's internal property registry.
     */
    public GDECanvasProperties (final JFrame window, final BLProperties properties) {
        super(window);
        
        this.properties = properties;

        final Box outerPane = new Box(BoxLayout.PAGE_AXIS);
        final Box mainPane = new Box(BoxLayout.PAGE_AXIS);
        final JButton changeButton = new JButton(new AbstractAction("Close") {
            /* Used for serialization purposes */

            private static final long serialVersionUID = 7526472295622777011L;

            public void actionPerformed(ActionEvent e) {
                // close the properties window
                dispose();
            }
        });

        // add the outer
        outerPane.add(mainPane);
        outerPane.add(changeButton);

        PropertiesNumber fontChangeBox = new PropertiesNumber(properties, "Font size",
                "font.size", 10,
                100);
        PropertiesCheckbox boldCB = new PropertiesCheckbox(properties, "Use bold fonts", "font.bold");

        mainPane.add(fontChangeBox);
        mainPane.add(boldCB);

        add(outerPane);
        setLocationRelativeTo(window);
        pack();
        setVisible(true);
        setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
    }
}
