/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.biolegato.gdesupport.canvas;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import org.biolegato.core.properties.*;

/**
 * Class used to create widgets to obtain boolean values for properties.
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class PropertiesCheckbox extends JCheckBox implements ActionListener,
                                                             PropertiesListener {

    /**
     * The key in ther properties hashtable that corresponds to the widget.
     */
    private String propertyKey;
    /**
     * The BLProperties object to associate the widget to.
     */
    private BLProperties properties;
    /**
     * Used for serialization purposes
     */
    private static final long serialVersionUID = 7526472295622777010L;

    /**
     * Creates a new instance of PropertiesCheckbox
     *
     * @param properties the properties object to associate the widget to.
     * @param name the label to display for the properties widget.
     * @param propertyKey the key in the properties hash corresponding to the widget.
     */
    public PropertiesCheckbox (BLProperties properties, String name,
                               String propertyKey) {
        super(name);

        this.propertyKey = propertyKey;
        this.properties = properties;

        setSelected("true".equalsIgnoreCase(properties.getProperty(propertyKey)));
        properties.addPropertiesListener(propertyKey, this);
        this.addActionListener(this);
    }

    /**
     * Handles changes in the status of the checkbox.
     *
     * @param e ignored by this function.
     */
    public void actionPerformed (ActionEvent e) {
        properties.setProperty(propertyKey, (isSelected() ? "true" : "false"));
    }

    /**
     * Handles changes in the status of the associated properties key.
     *
     * @param key used to confirm the right key is being updated.
     * @param value currently ignored by this function.
     */
    public void propertiesUpdate (String key, String value) {
        if (key != null && key.equalsIgnoreCase(propertyKey)) {
            setSelected("true".equalsIgnoreCase(properties.getProperty(propertyKey)));
        }
    }

}
