/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.biolegato.gdesupport.canvas;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.biolegato.core.properties.*;

/**
 * Class used to create widgets to obtain numerical values for properties.
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class PropertiesNumber extends Box implements ChangeListener,
                                                     PropertiesListener {

    /**
     * The JSpinner object to set the value with.
     */
    JSpinner spinner;
    /**
     * The key in ther properties hashtable that corresponds to the widget.
     */
    private String propertyKey;
    /**
     * The BLProperties object to associate the widget to.
     */
    private BLProperties properties;
    /**
     * Used for serialization purposes
     */
    private static final long serialVersionUID = 7526472295622777036L;

    /**
     * Creates a new instance of PropertiesNumber
     *
     * @param properties the properties object to associate the widget to.
     * @param name the label to display for the properties widget.
     * @param propertyKey the key in the properties hash corresponding to the widget.
     * @param min the minimum numerical value for the widget.
     * @param max the maximum numerical value for the widget.
     */
    public PropertiesNumber (BLProperties properties, String name,
                             String propertyKey, int min, int max) {
        super(BoxLayout.LINE_AXIS);

        this.propertyKey = propertyKey;
        this.properties = properties;

        add(new JLabel(name));
        properties.addPropertiesListener(propertyKey, this);
        spinner = new JSpinner(new SpinnerNumberModel(((min + max) / 2), min,
                                                      max, 1));
        propertiesUpdate(propertyKey, properties.getProperty(propertyKey));
        spinner.addChangeListener(this);
        add(spinner);
    }

    /**
     * Handles changes in the status of the spinner.
     *
     * @param e ignored by this function.
     */
    public void stateChanged (ChangeEvent e) {
        properties.setProperty(propertyKey, spinner.getValue().toString());
    }

    /**
     * Handles changes in the status of the associated properties key.
     *
     * @param key used to confirm the right key is being updated.
     * @param value currently ignored by this function.
     */
    public void propertiesUpdate (String key, String value) {
        if (key != null && key.equalsIgnoreCase(propertyKey)) {
            try {
                spinner.setValue(Integer.parseInt(properties.getProperty(
                        propertyKey)));
            } catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
        }
    }
}
