/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.biolegato.gdesupport.canvas.colourmap;

import org.biolegato.gdesupport.canvas.textarea.BLTextArea;
import java.awt.Color;
import java.awt.Graphics;
import org.biolegato.gdesupport.canvas.data.Cell;

/**
 * A standard monochrome colour map.
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class MonochromeColourMap extends ColourMap {

    /**
     * Creates a new instance of MonochromeColourMap
     */
    public MonochromeColourMap () {
    }

    /**
     * Creates a new instance of MonochromeColourMap
     *
     * @param foreground the colour to use as the foreground for unselected text.
     * @param background the colour to use as the background for unselected text.
     * @param foregroundSelect the colour to use as the foreground for selected text.
     * @param backgroundSelect the colour to use as the background for selected text.
     */
    public MonochromeColourMap (Color foreground, Color background) {
        this.foreground = foreground;
        this.background = background;
    }

    /**
     * Draws a sequence mapping the appropriate colours to each character rendered.
     *
     * @param ta the textarea to use for obtaining metrics from.
     * @param gfx the graphics object to draw the string to.
     * @param xstart the x co-ordinate to start drawing from.
     * @param ystart the y co-ordinate to start drawing from.
     * @param seq the sequence to draw.
     */
    @Override
    public void regularDrawString (BLTextArea ta, Graphics gfx, int xstart, int ystart, Cell seq, char[] array, int pstart, int pend) {
        drawChars(ta, gfx, xstart, ystart, array, pstart, pend, foreground, background);
    }
}
