package org.biolegato.gdesupport.canvas.colourmask;

import java.util.List;
import org.biolegato.gdesupport.canvas.colourmap.*;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.LinkedList;
import org.biolegato.core.main.BLMain;
import org.biolegato.gdesupport.canvas.colourmap.PositionColourMap;

/**
 * Used to select colour masks.
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class GDEColourMaskFile extends ColourMaskReader {
    /**
     * Creates a new instance of GDEColourMaskFile
     */
    public GDEColourMaskFile() {
    }

    /**
     * Reads and parses a colour mask file.
     *
     * @param file the file to read.
     * @return an array of colour masks defined by the file.
     */
    public ColourMap[] readColourMapFile(File file) {
	int number = 1;
	int length = 0;
	Color addColour = null;
	String name = "";
	boolean stopSequence = false;
	boolean nodash = false;
	BufferedReader reader = null;
	PositionColourMap mask = null;
	List<Color> colourList = new LinkedList<Color>();
	List<ColourMap> colourMapList = new LinkedList<ColourMap>();
	String line = "";
	
	if (file != null && file.exists() && file.isFile()) {
	    try {
		reader = new BufferedReader(new FileReader(file.getPath()));
		do {
		    line = reader.readLine();
		    if (line != null) {
			line = line.trim().toLowerCase();
			if (line.startsWith("name:")) {
			    name = line.substring(line.indexOf("name:") + 5);
			} else if (line.startsWith("length:")) {
			    try {
				length = Integer.parseInt(line.substring(line.indexOf("length:") + 7));
			    } catch (Throwable nfe) {
				nfe.printStackTrace();
			    }
			} else if (line.startsWith("nodash:")) {
			    nodash = true;
			} else if (!"".equals(name) && line.toLowerCase().startsWith("start:")) {
			    stopSequence = false;
			    while (!stopSequence && length > 0 && line != null) {
				line = reader.readLine();
				addColour = null;
				if (line != null) {
				    line = line.trim();
				    if (line.toLowerCase().startsWith("name:") || line.toLowerCase().startsWith("length:")
				    || line.toLowerCase().startsWith("nodash:") || line.toLowerCase().startsWith("start:")) {
					stopSequence = true;
				    } else if (BLMain.testNumber(line.toCharArray())) {
					addColour = getDefaultColour(stringToInt(line));
				    }
				    if (addColour != null) {
					colourList.add(addColour);
					length--;
				    }
				}
			    }
			    if (length != 0) {
				BLMain.error("Reached end of file before end of colour", "GDEColourMaskColourMap");
			    }
			    // handle duplicae names
			    number = 1;
			    mask = new PositionColourMap(name, colourList.toArray(new Color[0]), nodash);
			    
			    // add the map to the list
			    colourMapList.add(mask);
			    colourList.clear();
			    
			    // reset values for next pass
			    nodash = false;
			    name = "";
			} else if ("".equals(name) && line.toLowerCase().startsWith("start:")) {
			    BLMain.error("Unnamed colour mask", "GDEColourMaskColourMap");
			}
		    }
		} while (line != null);
	    } catch (Throwable exception) {
		exception.printStackTrace();
	    }
	} else {
	    BLMain.error("Invalid colour map file", "GDEColourMaskColourMap");
	}
	
	return colourMapList.toArray(new ColourMap[0]);
    }

    @Override
    public boolean accept (File f) {
        return true;
    }

    @Override
    public String getDescription () {
        return "GDE colour mask file";
    }
   
    /**
     * Returns a standard colour from the properties
     *
     * @param number the colour number to retrieve from the pallet.
     * @return the colour object corresponding to the number.
     */
    public static Color getDefaultColour(int number) {
	return new Color(stringToInt(BLMain.getProperty("GDE.colour." + number + ".red")),
			stringToInt(BLMain.getProperty("GDE.colour." + number + ".green")),
			stringToInt(BLMain.getProperty("GDE.colour." + number + ".blue")));
    }
    
    /**
     * Converts a string to an integer (note: returns 0 on failure).
     *
     * @param s the string to convert.
     * @return the integer representation of the string, 0 on failure.
     */
    public static int stringToInt (String s) {
	int i = 0;
	if (BLMain.testNumber(s.toCharArray())) {
	    try {
		i = Integer.parseInt(s);
	    } catch (Throwable th) {
	    }
	}
	return i;
    }
}