/*
 * ColumnlListener.java
 *
 * Created on June 9, 2009, 2:52 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.biolegato.gdesupport.canvas.data;

/**
 * This listener received change events from sequences.
 * <p>A change event occurs when a field within a Cell object is modified.</p>
 * 
 * 
 * 
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public interface CellListener {
    /**
     * This method is called when a field in a sequence is modified.
     *
     * @param sequence the sequence which was modified.
     * @param key the key of the modified field within the sequence.
     */
    public void sequenceChanged(Cell sequence, String key);
}
