/*
 * DatasetListener.java
 *
 * Created on June 9, 2009, 2:52 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.biolegato.gdesupport.canvas.data;

import org.biolegato.gdesupport.canvas.data.Cell;

/**
 * The listener class for sequence document objects.
 * <p>
 *  This interface is used to receive document changes within a Dataset file.
 *  All Dataset listeners will receive notification when sequences are added to,
 *  changed within or removed from the Dataset.  Notification for sequence modification
 *  will be sent if the sequence is inside the Dataset structure regardless of whether
 *  the modification originated from the containing Dataset class.
 * </p>
 * 
 * 
 * 
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public interface GDEModelListener {
    /**
     * This method is called when a sequence is added to a Dataset.
     * 
     * 
     * 
     * @param source the source of the sequence insertion event.
     * @param index the location (line number) where the sequence was added within the SeDatasettructure.
     * @param sequence the sequence object added to the SeqDatasetructure.
     */
    public void sequenceAdded(GDEModel source, int index, Cell sequence);
    /**
     * This method is called when a field in a sequence is modified.  The field may either be
     * modified by the Dataset class or by an external class so long as the sequence is contained
     * within the Dataset class.
     * 
     * 
     * 
     * @param source the source of the sequence alteration message.
     * @param index the location (line number) of the sequence which was modified.
     * @param sequence the modified sequence object.
     * @param key the field key of the sequence object which was modified.
     */
    public void sequenceChanged(GDEModel source, int index, Cell sequence, String key);
    /**
     * This method is called when a sequence is removed from the Dataset class.
     * 
     * 
     * 
     * @param source the source of the sequence removal message.
     * @param index the location (line number) where the sequence was removed from.
     * @param sequence the sequence removed from the SeqDataset
     */
    public void sequenceRemoved(GDEModel source, int index, Cell sequence);
}
