/*
 * UndoRowDeletion.java
 *
 * Created on February 16, 2010, 2:09 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.biolegato.gdesupport.canvas.undo;

import org.biolegato.gdesupport.canvas.data.Cell;
import org.biolegato.gdesupport.canvas.data.GDEModel;

/**
 * This object handles undoing sequence row deletions
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class UndoRowDeletion implements Undoable {
    
    /**
     * The lineNumber of the deletion
     */
    private int lineNumber;
    /**
     * The deleted sequence
     */
    private Cell deleted;
    /**
     * The source of the deletion
     */
    private GDEModel source;
    
    /**
     * Creates a new instance of UndoRowDeletion
     */
    public UndoRowDeletion(GDEModel source, int lineNumber, Cell deleted) {
	this.source = source;
	this.lineNumber = lineNumber;
	this.deleted = deleted;
    }
    
    /**
     * Undoes a row deletion
     *
     * @return an object which can redo the undone operation.
     */
    public Undoable undo() {
	source.addSequence(lineNumber, deleted);
	return new UndoRowInsertion(source, lineNumber);
    }
}
