/*
 * UndoRowInsertion.java
 *
 * Created on February 16, 2010, 2:09 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.biolegato.gdesupport.canvas.undo;

import org.biolegato.gdesupport.canvas.data.Cell;
import org.biolegato.gdesupport.canvas.data.GDEModel;

/**
 * This object handles undoing sequence row inesrtions
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class UndoRowInsertion implements Undoable {
    
    /**
     * The lineNumber of the insertion
     */
    private int lineNumber;
    /**
     * The source of the insertion
     */
    private GDEModel source;
    
    /**
     * Creates a new instance of UndoRowInsertion
     */
    public UndoRowInsertion(GDEModel source, int lineNumber) {
	this.source = source;
	this.lineNumber = lineNumber;
    }
    
    /**
     * Undoes a row insertion
     *
     * @return an object which can redo the undone operation.
     */
    public Undoable undo() {
	Undoable result = new UndoRowDeletion(source, lineNumber, source.get(lineNumber));
	source.removeSequences(new int[]{lineNumber});
	return result;
    }
}
