package org.biolegato.tables;
/*
 * CSVFile.java
 *
 * Created on January 30, 2008, 11:58 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedList;

/**
 * FastA file format parser.
 *
 * NOTE: this parser will automatically detect whether the sequence is protein, RNA or DNA.
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class CSVFile extends FileFilter{

    /**
     * Creates a new instance of CSVFile
     */
    public CSVFile () {
    }
    /**
     * Determines whether or not a specified file is of type GenBank file (based on extension).
     * Currently the only extensions supported are ".wrp", ".fasta", and ".fsa".
     *
     * @param file the file to test
     * @return true if the file is of type FastA file (otherwise false)
     * @see javax.swing.filechooser.FileFilter#accept
     */
    public boolean accept (File file) {
        return (file.isDirectory() ||
                file.getAbsolutePath().toLowerCase().endsWith(".csv"));
    }
    /**
     * Returns a description of the file format that can be displayed to the user.
     *
     * @return the string description of the file format
     * @see javax.swing.filechooser.FileFilter#getDescription
     */
    public String getDescription () {
        return "CSV - Comma Separated Values - file (*.csv)";
    }
    /**
     * Used to auto-detect Bio Legato formats
     *
     * @param test the reader to parse data from
     * @return whether or not the format is correct
     */
    public boolean isFormat (Reader test) {
        int check = ' ';
        try {
            while (check != '\n' && check != '\r' && check != ',') {
                test.mark(2);
                check = test.read();
            }
            test.reset();
        } catch (Throwable e) {
            e.printStackTrace();
        }
        return (check == ',');
    }

    public static String[][] readFile(File currentFile) {
        String line;
        List<String> row = new LinkedList<String>();
        List<String[]> dataIn = new LinkedList<String[]>();
        BufferedReader reader;
        
        try {
            reader = new BufferedReader(new FileReader(currentFile));
            
            while ((line = reader.readLine()) != null) {
                dataIn.add(line.split("\t"));
            }
        } catch (Throwable th) {
            th.printStackTrace();
        }

for (int y = 0; y < dataIn.size(); y++) {
    for (int x = 0; x < dataIn.get(y).length; x++) {
        if (x > 0) {
            System.out.print(',');
        }
        System.out.print(dataIn.get(y)[x]);
    }
    System.out.print('\n');
}
        return dataIn.toArray(new String[0][]);
    }

    public static void writeFile(File currentFile, String[][] data) {
        FileWriter writer;   // the file writer object to write the file with.
        
        try {
            writer = new FileWriter(currentFile);
            
            // translate and write the file.
            for (int y = 0; y < data.length; y++) {
                if (data[y].length > 0) {
                    writer.append('\"');
                    writer.append(data[y][0].replaceAll("\"", "\"\""));
                    writer.append('\"');
                }
                for (int x = 1; x < data[y].length; x++) {
                    writer.append(',');
                    writer.append('\"');
                    writer.append(data[y][x].replaceAll("\"", "\"\""));
                    writer.append('\"');
                }
                writer.append('\n');
            }
        
            // flush and close the file writer buffer.
            writer.flush();
            writer.close();
        } catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}
