package org.biolegato.tables;

import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.biolegato.core.main.BLMain;
import org.biolegato.core.plugintypes.DataCanvas;
/*
 * TableCanvas.java
 *
 * Created on November 15, 2010, 4:08 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

/**
 *
 * @author alvare
 */
public class TableCanvas extends JScrollPane implements DataCanvas {
    DefaultTableModel tableModel = new DefaultTableModel();
    JTable tablePane = new JTable(tableModel);
    
    /**
     * Creates a new instance of TableCanvas
     */
    public TableCanvas() {
        super(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        
        setViewportView(tablePane);
        tablePane.setCellSelectionEnabled(true);
        tablePane.setColumnSelectionAllowed(true);
        tablePane.setRowSelectionAllowed(true);
        
        //////////////////////////////////////
        //**********************************//
        //* ADD THE DEFAULT TOP MENU ITEMS *//
        //**********************************//
        //////////////////////////////////////

        /*************************
         * Add the "Open" button *
         *************************/
        BLMain.addMenuItem(0, "File", new JMenuItem(new AbstractAction("Open...") {

            private static final long serialVersionUID = 7526472295622776157L;	    /* Serialization number - required for no warnings*/


            {
                putValue(MNEMONIC_KEY, new Integer(java.awt.event.KeyEvent.VK_O));
            }  /* Sets the mnemonic for the event */


            public void actionPerformed(java.awt.event.ActionEvent evt) {           /* Event handler - open the file */
                JFileChooser openDialog = new JFileChooser();
		File[] openFiles;

                openDialog.setCurrentDirectory(BLMain.getCurrentPWD());
                openDialog.setAcceptAllFileFilterUsed(false);
		openDialog.setMultiSelectionEnabled(true);
                openDialog.addChoosableFileFilter(new CSVFile());
                
                // if a file is selected, open it
                if (openDialog.showOpenDialog(BLMain.getJFrame()) ==
                        JFileChooser.APPROVE_OPTION) {
		    if (openDialog.getSelectedFiles() != null) {
			openFiles = openDialog.getSelectedFiles();
			for (File ofile : openFiles) {
			    if (ofile.exists() && ofile.isFile()) {
				try {
				    /*if (openDialog.getFileFilter() != null && !openDialog.getFileFilter().equals(
					    openDialog.getAcceptAllFileFilter())) {
                                        datamodel.addSequences(((org.biolegato.gdesupport.formats.DataFormat) openDialog.getFileFilter()).readFile(ofile));
				    } else {
					datamodel.addSequences(
						org.biolegato.gdesupport.formats.DataFormat.auto(ofile));
				    }*/
                                    readFile("csv", ofile);
				} catch (Throwable e) {
				    e.printStackTrace();
				}
			    }
			}
		    }
		    if (openDialog.getCurrentDirectory() != null) {
			BLMain.setCurrentPWD(openDialog.getCurrentDirectory());
		    }
                }
            }
        }));

        /*******************************
         * Add the "Save As..." button *
         *******************************/
        BLMain.addMenuItem(1, "File", new JMenuItem(new AbstractAction("Save As...") {

            private static final long serialVersionUID = 7526472295622776157L;	    /* Serialization number - required for no warnings*/


            {
                putValue(MNEMONIC_KEY, new Integer(java.awt.event.KeyEvent.VK_S));
            }  /* Sets the mnemonic for the event */


            public void actionPerformed(java.awt.event.ActionEvent evt) {	    /* Event handler - save the file */
                JFileChooser saveDialog = new JFileChooser();

                saveDialog.setCurrentDirectory(BLMain.getCurrentPWD());
                saveDialog.setAcceptAllFileFilterUsed(false);
                saveDialog.addChoosableFileFilter(new CSVFile());
                
                // if a file is selected, save to it
                if (saveDialog.showSaveDialog(BLMain.getJFrame()) ==
                        JFileChooser.APPROVE_OPTION &&
                        saveDialog.getSelectedFile() != null &&
                        (!saveDialog.getSelectedFile().exists() ||
                        javax.swing.JOptionPane.showConfirmDialog(null,
                        "Overwrite existing file?", "Overwrite", javax.swing.JOptionPane.OK_CANCEL_OPTION,
                        javax.swing.JOptionPane.QUESTION_MESSAGE) != javax.swing.JOptionPane.CANCEL_OPTION)) {
                    // write the file
                    try {
                        writeFile("", saveDialog.getSelectedFile());
                    } catch (Throwable e) {
                        e.printStackTrace();
                    }
		    if (saveDialog.getCurrentDirectory() != null) {
			BLMain.setCurrentPWD(saveDialog.getCurrentDirectory());
		    }
                }
            }
        }));
    }
    
    /**
     * Returns the current/selected data in the canvas.
     *
     * @return the current data for usage by commands
     */
    public String[][] getData() {
        int[] rows = tablePane.getSelectedRows();
        int[] columns = tablePane.getSelectedColumns();
        
        // TODO: fix
        String[][] result = new String[rows.length][];
        
        // TODO: fix
        if (rows != null && columns != null) {
            for (int y : rows) {
                result[y] = new String[columns.length];
                for (int x : columns) {
                    result[y][x] = (String)tableModel.getValueAt(y, x);
                }
            }
        }
        return result;
    }
    
    /**
     * Returns the name of the canvas.
     *
     * @return the name to display for the canvas in all program text referring to it.
     */
    public String getTabName() {
        return "Table";
    }
    
    /**
     * Refreshes the canvas on tab changes.
     * Override this method, if you wish to do anything special on tab changes.
     *
     * @param event used to determine whether or not to refresh/
     */
    public void stateChanged(javax.swing.event.ChangeEvent event) {
    }

    /**
     * Reads a file into the canvas
     **
     * @param format the file format to use for parsing the file.
     * @param currentFile the file to read in.
     */
    public void readFile(String format, File currentFile) {
        String[][] dataIn;
        
        try {
            // TODO: add more formats
            //if (format.equalsIgnoreCase("csv")) {
            dataIn = CSVFile.readFile(currentFile);
            for (String[] row : dataIn) {
                while (tableModel.getColumnCount() < row.length) {
                    tableModel.addColumn("" + tableModel.getColumnCount());
                }
                tableModel.addRow(row);
            }
            //}
        } catch (Throwable th) {
            th.printStackTrace();
        }
    }

    /**
     * Writes a file out from the canvas
     **
     * @param format the file format to use for writing the file.
     * @param currentFile the file to write out.
     */
    public void writeFile(String format, File currentFile) {
        try {
            CSVFile.writeFile(currentFile, getData());
        } catch (Throwable th) {
            th.printStackTrace();
        }
    }
}
