
package org.biolegato.menu;

import java.awt.Container;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;

/**
 * A wrapper class used to abstract choice lists within command windows.
 **
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class ChoiceList extends ListWidget {
    /**
     * The list containing the data.
     */
    protected JList choice_list = null;
    /**
     * Used for serialization purposes.
     */
    private static final long serialVersionUID = 7526472295622776158L;
    
    /**
     * Creates a new instance of GDEComboBox (represents "choice_list" in GDE menu files).
     **
     * @param data the data to create the combobox with.
     */
    public ChoiceList(String label, String[] names, String[] values, int index) {
        super(label, names, values, index);
    }
    
    /**
     * Returns the value of the variable.
     **
     * @return the current value of the widget.
     */
    public Object getValue() {
        return values[choice_list.getSelectedIndex()];
    }
    
    /**
     * Displays the choice list
     **
     * @param dest the destination to display the choice list widget
     */    
    public void display(Container dest) {
        Box result = new Box(BoxLayout.LINE_AXIS);
        int defaultEntry = 0;
        String[] orderChoices = null;         // used for default values
        
        if (label != null) {
            result.add(new JLabel(label));
        }
        // a combo box which returns its value when toString is called
        choice_list = new JList(names);
        
        // handle the default value for the list
        choice_list.setSelectedIndex(index);

        // make the choice_list only support single selection
        choice_list.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        
        // add the choice list (and make it scrollable)
        result.add(new JScrollPane(choice_list, JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED, JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED));
        
        dest.add(result);
    }
    /**
     * Closes the open object
     */
    public void close() {
        index = choice_list.getSelectedIndex();
        choice_list = null;
    }
}
