package org.biolegato.menu;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;

/**
 * Creates a JButton, which when clicked runs internal API functions or external commands
 **
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class CommandButton {
    private String label = null;
    private boolean close = false;
    private String command = null;
    private Map<String, Widget> widgets = null;
    
    /**
     * Creates a new instance of CommandButton
     */
    public CommandButton(Map<String, Widget> widgets, String label, String command, boolean close) {
        this.label = label;
        this.command = command;
        this.close = close;
        this.widgets = widgets;
    }
    
    public void display(Container dest, final RunWindow window) {
        JButton button = new JButton(label);

        if (close) {
            button.addActionListener(window.CLOSE_ACTION);
        }
        button.addActionListener(new CommandThread(command, widgets));
        dest.add(button);
    }
    
}
