/*
 * CommandThread.java
 *
 * Created on January 6, 2010, 4:12 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.biolegato.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import org.biolegato.main.BLMain;

/**
 * Class used for making abstract actions which launch threads.
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class CommandThread implements ActionListener, Runnable {
    
    private Map<String,Widget> widgets = null;
    /**
     * The action to perform.
     */
    private String command = null;
    /**
     * This constant is used for serialization
     */
    private static final long serialVersionUID = 7526472295622777001L;
    
    /**
     * Creates a new instance of CommandThread.
     **
     * @param command the command for the thread to run
     */
    public CommandThread(String command) {
        this(command, null);
    }

    /**
     * Creates a new instance of CommandThread.
     *
     * @param command the command for the thread to run
     */
    public CommandThread(String command, Map<String, Widget> widgets) {
        this.command = command;
        this.widgets = widgets;
    }
    
    /**
     * Runs the command.
     *
     * @param e ignored by this function
     */
    public void actionPerformed(ActionEvent e) {
        new Thread(this).start();
    }
    
    /**
     * Used for running the command.
     * <p>
     *	This function gathers all of the parameter settings from the widgets,
     *	then generates and executes the corresponding command string.
     * </p>
     */
    public void run() {
        if (widgets == null) {
            // execute the program and collect program output
            BLMain.shellCommand(command, "");
        } else {
            // execute the program and collect program output
            BLMain.shellCommand(replaceArguments(command), "");
            
            // cleanup execution
            // releases all of the input files
            for (Widget var : widgets.values()) {
                var.close();
            }
        }
    }
    
    /**
     * Replaces the variables in the command string with their corresponding values.
     **
     * @param run the command to do the replacements on.
     * @param widgets the widget variables to use for string replacement.
     * @param files the file variables to use for string replacement.
     * @return the altered command string.
     */
    protected String replaceArguments(String run) {
        int start = -1;
        int end = 0;
        String name = "";
        String value = "";
        
        if (BLMain.debug) {
            BLMain.message("--- debug keys ---", "replaceArguments");
            for (String key : widgets.keySet()) {
                BLMain.message("key - " + key + "=" + widgets.get(key), "replaceArguments");
            }
        }
        
        // create the command string (NOTE: variable.toString().replaceAll(Pattern.quote("$"), "\\\\\\$") is used to prevent regex grouping (e.g. $0, etc.))
        while (end >= 0 && (start = run.indexOf('%', start)) >= 0) {
            end = run.indexOf('%', start + 1);
            if (start < end) {
                name = run.substring(start + 1, end);
                if (widgets.containsKey(name)) {
                    value = widgets.get(name).getValue().toString();
                    run = (start == 0 ? "" : run.substring(0, start)) + value + (end >= run.length() ? "" : run.substring(end + 1));
                    start--;
                } else {
                    start++;
                }
            }
        }
        return run;
    }
}
