package org.biolegato.menu;

import java.awt.Container;


/**
 * Abstract interface to relate widget variables and invisible variables (such as temporary files)
 **
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public interface Widget {

    /**
     * Returns the value of the variable.
     **
     * @return the value of the variable
     */
    public Object getValue ();

    /**
     * Displays the current object
     **
     * @param dest the destination to display the widget
     */    
    public void display(Container dest);

    /**
     * Notifies the variable that the program has now completed successfully, and it can
     * perform any closing operations
     */
    public void close ();
}
