/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.biolegato.gdesupport.canvas;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/**
 * A class for adding GDE canvas specific properties to.
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class GDECanvasProperties extends JDialog implements ActionListener, ChangeListener {
    GDECanvas canvas;
    final SpinnerNumberModel fontSizeSP = new SpinnerNumberModel(50, 6, 94, 1);
    final JCheckBox boldCB = new JCheckBox("Bold");
    final JButton closeB = new JButton("Close");
    /**
     * Used for serialization purposes
     */
    private static final long serialVersionUID = 7526472295622777011L;

    /**
     * Creates a new GDECanvasProperties object.
     **
     * @param window the parent window
     * @param canvas the canvas associated with its properties
     */
    public GDECanvasProperties (final JFrame window, final GDECanvas canvas) {
        super(window);
        
        this.canvas = canvas;

        final Box outerPane = new Box(BoxLayout.PAGE_AXIS);
        final Box mainPane = new Box(BoxLayout.PAGE_AXIS);

        // add the outer
        outerPane.add(mainPane);
        outerPane.add(closeB);

        closeB.addActionListener(this);

        add(new JLabel("Font size"));
        JSpinner sizeSP = new JSpinner(fontSizeSP);
        sizeSP.setValue(canvas.currentFont.getSize());
        sizeSP.addChangeListener(this);
        mainPane.add(sizeSP);

        boldCB.setSelected(canvas.currentFont.isBold());
        boldCB.addActionListener(this);
        mainPane.add(boldCB);

        add(outerPane);
        setLocationRelativeTo(window);
        pack();
        setVisible(true);
        setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == fontSizeSP) {
            canvas.updateFont(fontSizeSP.getNumber().intValue(), boldCB.isSelected());
        }
    }

    public void actionPerformed(ActionEvent e) {
        canvas.updateFont(fontSizeSP.getNumber().intValue(), boldCB.isSelected());
        if (e.getSource() == closeB) {
            dispose();
        }
    }
}
