/*
 * SelectByNameWindow.java
 *
 * Created on June 18, 2009, 2:18 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
package org.biolegato.gdesupport.canvas;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListModel;

/**
 * A class to provide the functionality of selecting/deselecting sequences based on name.
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class SelectByNameWindow extends JDialog implements ActionListener {

    /**
     * The list to search for and select/deselect sequences from.
     */
    private JList list;
    /**
     * Used for obtaining the name to search for
     */
    private JTextField nameSelector = new JTextField();
    /**
     * The button used to select the sequences based on their name
     */
    private JButton selectButton = new JButton("Select");
    /**
     * The button used to deselect the sequences based on their name
     */
    private JButton deselectButton = new JButton("Deselect");
    /**
     * The button used to close the window
     */
    private JButton closeButton = new JButton("Close");
    /**
     * Used for serialization purposes
     */
    private static final long serialVersionUID = 7526472295622776150L;

    /**
     * Creates a new instance of SelectByNameWindow
     **
     * @param window the parent window
     * @param list the list to perform selection/deselection on
     */
    public SelectByNameWindow (JFrame window, JList list) {
        super(window, "Select by name");

        // set the class's local variables
        this.list = list;

        // create the main panel
        Box mainPanel = new Box(BoxLayout.PAGE_AXIS);

        // create a panel for entering the name to search for
        Box entryPanel = new Box(BoxLayout.LINE_AXIS);
        entryPanel.add(new JLabel("Name:"));
        entryPanel.add(nameSelector);
        mainPanel.add(entryPanel);

        // create a panel to contain all of the buttons
        Box buttonPanel = new Box(BoxLayout.LINE_AXIS);
        buttonPanel.add(selectButton);
        buttonPanel.add(deselectButton);
        buttonPanel.add(closeButton);
        mainPanel.add(buttonPanel);

        // configure the select button
        selectButton.addActionListener(this);
        selectButton.setActionCommand("select");
	
        // configure the deselect button
        deselectButton.addActionListener(this);
        deselectButton.setActionCommand("deselect");

        // configure the close button
        closeButton.addActionListener(this);
        closeButton.setActionCommand("close");
	
        // configure the name textbox button
        nameSelector.addActionListener(this);
	nameSelector.setActionCommand("select");

        // create the window
        add(mainPanel);
        pack();
        setLocationRelativeTo(window);
        setVisible(true);
	setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
    }

    /**
     * Handles the button commands for the given window.
     *
     * @param e determines which button was pressed.
     */
    public void actionPerformed (ActionEvent e) {
        String test = nameSelector.getText().toLowerCase();     // the text to search for when selecting or deselecting
        ListModel model = list.getModel();                      // the list model to search for the names

        if ("select".equals(e.getActionCommand())) {
            // select the sequences based on name
            for (int count = 0; count < model.getSize(); count ++) {
                if (model.getElementAt(count).toString().toLowerCase().contains(
                        test)) {
                    list.addSelectionInterval(count, count);
                }
            }
        } else if ("deselect".equals(e.getActionCommand())) {
            // deselect the sequences based on name
            for (int count = 0; count < model.getSize(); count ++) {
                if (model.getElementAt(count).toString().toLowerCase().contains(
                        test)) {
                    list.removeSelectionInterval(count, count);
                }
            }

        } else if ("close".equals(e.getActionCommand())) {
	    dispose();
        }
    }
}
