package org.biolegato.tables;

import java.awt.Component;
import java.io.File;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import org.biolegato.main.BLMain;
import org.biolegato.main.DataCanvas;
/*
 * TableCanvas.java
 *
 * Created on November 15, 2010, 4:08 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

/**
 *
 * @author alvare
 */
public class TableCanvas extends JScrollPane implements DataCanvas {

    DefaultTableModel tableModel = new DefaultTableModel();
    JTable tablePane = new JTable(tableModel);
    private static final String[][] EMPTY_DATA = new String[0][0];
    private static final FileFilter CSV_FILTER = new CSVFile();
    private static final FileFilter TSV_FILTER = new TSVFile();

    /**
     * Creates a new instance of TableCanvas
     */
    public TableCanvas() {
        super(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);

        setViewportView(tablePane);
        tablePane.setCellSelectionEnabled(true);
        tablePane.setColumnSelectionAllowed(true);
        tablePane.setRowSelectionAllowed(true);

        //////////////////////////////////////
        //**********************************//
        //* ADD THE DEFAULT TOP MENU ITEMS *//
        //**********************************//
        //////////////////////////////////////

        /*************************
         * Add the "Open" button *
         *************************/
        BLMain.addMenuItem(0, "File", new JMenuItem(new AbstractAction("Open...") {

            private static final long serialVersionUID = 7526472295622776157L;	    /* Serialization number - required for no warnings*/


            {
                putValue(MNEMONIC_KEY, new Integer(java.awt.event.KeyEvent.VK_O));
            }  /* Sets the mnemonic for the event */


            public void actionPerformed(java.awt.event.ActionEvent evt) {           /* Event handler - open the file */
                JFileChooser openDialog = new JFileChooser();
                File[] openFiles;

                openDialog.setCurrentDirectory(BLMain.getCurrentPWD());
                openDialog.setAcceptAllFileFilterUsed(false);
                openDialog.setMultiSelectionEnabled(true);
                openDialog.addChoosableFileFilter(CSV_FILTER);
                openDialog.addChoosableFileFilter(TSV_FILTER);

                // if a file is selected, open it
                if (openDialog.showOpenDialog(BLMain.getJFrame())
                        == JFileChooser.APPROVE_OPTION) {
                    if (openDialog.getSelectedFiles() != null) {
                        openFiles = openDialog.getSelectedFiles();
                        for (File ofile : openFiles) {
                            if (ofile.exists() && ofile.isFile()) {
                                if (openDialog.getFileFilter() == CSV_FILTER) {
                                    readFile("csv", ofile);
                                } else {
                                    readFile("tsv", ofile);
                                }
                            }
                        }
                    }
                    if (openDialog.getCurrentDirectory() != null) {
                        BLMain.setCurrentPWD(openDialog.getCurrentDirectory());
                    }
                }
            }
        }));

        /*******************************
         * Add the "Save As..." button *
         *******************************/
        BLMain.addMenuItem(1, "File", new JMenuItem(new AbstractAction("Save As...") {

            private static final long serialVersionUID = 7526472295622776157L;	    /* Serialization number - required for no warnings*/


            {
                putValue(MNEMONIC_KEY, new Integer(java.awt.event.KeyEvent.VK_S));
            }  /* Sets the mnemonic for the event */


            public void actionPerformed(java.awt.event.ActionEvent evt) {	    /* Event handler - save the file */
                JFileChooser saveDialog = new JFileChooser();

                saveDialog.setCurrentDirectory(BLMain.getCurrentPWD());
                saveDialog.setAcceptAllFileFilterUsed(false);
                saveDialog.addChoosableFileFilter(new CSVFile());

                // if a file is selected, save to it
                if (saveDialog.showSaveDialog(BLMain.getJFrame())
                        == JFileChooser.APPROVE_OPTION
                        && saveDialog.getSelectedFile() != null
                        && (!saveDialog.getSelectedFile().exists() || (saveDialog.getSelectedFile().canWrite()
                        && JOptionPane.showConfirmDialog(null,
                        "Overwrite existing file?", "Overwrite", JOptionPane.OK_CANCEL_OPTION,
                        JOptionPane.QUESTION_MESSAGE) != JOptionPane.CANCEL_OPTION))) {
                    // write the file
                    if (saveDialog.getFileFilter() == CSV_FILTER) {
                        readFile("csv", saveDialog.getSelectedFile());
                    } else {
                        readFile("tsv", saveDialog.getSelectedFile());
                    }
                    if (saveDialog.getCurrentDirectory() != null) {
                        BLMain.setCurrentPWD(saveDialog.getCurrentDirectory());
                    }
                }
            }
        }));

        /*******************************
         * Add the "Delete Row" button *
         *******************************/
        BLMain.addMenuItem(0, "Edit", new JMenuItem(new AbstractAction("Delete Row") {

            private static final long serialVersionUID = 7526472295622776157L;	    /* Serialization number - required for no warnings*/


            {
                putValue(MNEMONIC_KEY, new Integer(java.awt.event.KeyEvent.VK_O));
            }  /* Sets the mnemonic for the event */


            public void actionPerformed(java.awt.event.ActionEvent evt) {           /* Event handler - open the file */
                int [] rowSelection = tablePane.getSelectedRows();
                Arrays.sort(rowSelection);
                for (int count = rowSelection.length - 1; count >= 0; count--) {
                    System.out.println("deleting row: " + rowSelection[count]);
                    tableModel.removeRow(rowSelection[count]);
                }
            }
        }));
    }

    /**
     * Returns the current/selected data in the canvas.
     *
     * @return the current data for usage by commands
     */
    public String[][] getData() {
        int[] rows = tablePane.getSelectedRows();
        int[] columns = tablePane.getSelectedColumns();

        // TODO: fix
        String[][] result = new String[rows.length][];

        // TODO: fix
        if (rows != null && columns != null) {
            for (int y = 0; y < rows.length; y++) {
                result[y] = new String[columns.length];
                for (int x = 0; x < columns.length; x++) {
                    result[y][x] = (String) tableModel.getValueAt(rows[y], columns[x]);
                }
            }
        }
        return result;
    }

    /**
     * Returns the name of the canvas.
     **
     * @return the name to display for the canvas in all program text referring to it.
     */
    @Override
    public String getName() {
        return "Table";
    }

    /**
     * Reads a file into the canvas
     **
     * @param format the file format to use for parsing the file.
     * @param currentFile the file to read in.
     */
    public void readFile(String format, File currentFile) {
        // TODO: add more formats
        if (format.equalsIgnoreCase("csv")) {
            CSVFile.readFile(tableModel, currentFile);
        } else if (format.equalsIgnoreCase("tsv")) {
            TSVFile.readFile(tableModel, currentFile);
        }
    }

    /**
     * Writes a file out from the canvas
     **
     * @param format the file format to use for writing the file.
     * @param currentFile the file to write out.
     */
    public void writeFile(String format, File currentFile) {
        if (format.equalsIgnoreCase("csv")) {
            CSVFile.writeFile(currentFile, getData());
        } else if (format.equalsIgnoreCase("tsv")) {
            TSVFile.writeFile(currentFile, getData());
        }
    }

    public Component display() {
        return this;
    }
}
